/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.debug.gdbjtag.core.services;

import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.ImmediateDataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Sequence;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.IMIProcesses;
import org.eclipse.cdt.dsf.mi.service.MIMemory;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.output.CLIShowEndianInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIDataEvaluateExpressionInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIGDBShowLanguageInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.embedcdt.debug.gdbjtag.core.services.IPeripheralMemoryService;
import org.eclipse.embedcdt.internal.debug.gdbjtag.core.Activator;
import org.osgi.framework.BundleContext;

public class PeripheralMemoryService
extends MIMemory
implements IPeripheralMemoryService {
    private ILaunchConfiguration fConfig = null;
    private IGDBControl fCommandControl;
    private DsfSession fSession;
    private DsfServicesTracker fTracker;
    private Boolean fIsBigEndian;
    private Integer fAddressSize;

    public PeripheralMemoryService(DsfSession session, ILaunchConfiguration launchConfiguration) {
        super(session);
        this.fSession = session;
        this.fConfig = launchConfiguration;
    }

    public void initialize(final RequestMonitor rm) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("PeripheralMemoryService.initialize()");
        }
        super.initialize((RequestMonitor)new ImmediateRequestMonitor(rm){

            protected void handleSuccess() {
                PeripheralMemoryService.this.doInitialize(rm);
            }
        });
    }

    private void doInitialize(RequestMonitor rm) {
        this.fCommandControl = (IGDBControl)this.getServicesTracker().getService(IGDBControl.class);
        this.register(new String[]{IPeripheralMemoryService.class.getName(), PeripheralMemoryService.class.getName()}, new Hashtable());
        if (Activator.getInstance().isDebugging()) {
            System.out.println("PeripheralMemoryService registered " + this);
        }
        this.fTracker = new DsfServicesTracker(Activator.getInstance().getBundle().getBundleContext(), this.fSession.getId());
        ICommandControlService commandControlService = (ICommandControlService)this.fTracker.getService(ICommandControlService.class);
        IMIProcesses processes = (IMIProcesses)this.fTracker.getService(IMIProcesses.class);
        if (commandControlService != null && processes != null) {
            IProcesses.IProcessDMContext processDMContext = processes.createProcessContext(commandControlService.getContext(), "");
            IMemory.IMemoryDMContext memoryDMContext = (IMemory.IMemoryDMContext)processes.createContainerContext(processDMContext, "");
            this.initializeMemoryData(memoryDMContext, rm);
            return;
        }
        rm.done();
    }

    public void shutdown(RequestMonitor rm) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("PeripheralMemoryService.shutdown()");
        }
        this.unregister();
        super.shutdown(rm);
    }

    protected BundleContext getBundleContext() {
        return Activator.getInstance().getBundle().getBundleContext();
    }

    @Override
    public void initializeMemoryData(IMemory.IMemoryDMContext memContext, RequestMonitor rm) {
        ImmediateExecutor.getInstance().execute((Runnable)((Object)new PeripheralSequence(memContext, this.getExecutor(), rm)));
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IExitedDMEvent event) {
        IMemory.IMemoryDMContext context;
        if (event.getDMContext() instanceof IRunControl.IContainerDMContext && (context = (IMemory.IMemoryDMContext)DMContexts.getAncestorOfType((IDMContext)event.getDMContext(), IMemory.IMemoryDMContext.class)) != null) {
            this.fAddressSize = null;
            this.fIsBigEndian = null;
        }
    }

    @Override
    public int getAddressSize(IMemory.IMemoryDMContext context) {
        return this.fAddressSize;
    }

    @Override
    public boolean isBigEndian(IMemory.IMemoryDMContext context) {
        assert (this.fIsBigEndian != null);
        if (this.fIsBigEndian == null) {
            Activator.log((IStatus)new Status(4, "org.eclipse.embedcdt.debug.gdbjtag.core", "Endianness was never initialized!"));
            return false;
        }
        return this.fIsBigEndian;
    }

    protected void readAddressSize(IMemory.IMemoryDMContext memContext, final DataRequestMonitor<Integer> drm) {
        IExpressions exprService = (IExpressions)this.getServicesTracker().getService(IExpressions.class);
        IExpressions.IExpressionDMContext exprContext = exprService.createExpression((IDMContext)memContext, "sizeof (void*)");
        CommandFactory commandFactory = this.fCommandControl.getCommandFactory();
        this.fCommandControl.queueCommand(commandFactory.createMIDataEvaluateExpression(exprContext), (DataRequestMonitor)new DataRequestMonitor<MIDataEvaluateExpressionInfo>(ImmediateExecutor.getInstance(), drm){

            protected void handleSuccess() {
                try {
                    Integer data = Integer.decode(((MIDataEvaluateExpressionInfo)this.getData()).getValue());
                    if (Activator.getInstance().isDebugging()) {
                        System.out.println("readAddressSize() " + data);
                    }
                    drm.setData((Object)data);
                }
                catch (NumberFormatException e) {
                    drm.setStatus((IStatus)new Status(4, "org.eclipse.embedcdt.debug.gdbjtag.core", String.format("Invalid address size: %s", ((MIDataEvaluateExpressionInfo)this.getData()).getValue())));
                }
                drm.done();
            }
        });
    }

    protected void readEndianness(IMemory.IMemoryDMContext memContext, final DataRequestMonitor<Boolean> drm) {
        CommandFactory commandFactory = this.fCommandControl.getCommandFactory();
        this.fCommandControl.queueCommand(commandFactory.createCLIShowEndian(memContext), (DataRequestMonitor)new DataRequestMonitor<CLIShowEndianInfo>(ImmediateExecutor.getInstance(), drm){

            protected void handleSuccess() {
                Boolean data = ((CLIShowEndianInfo)this.getData()).isBigEndian();
                if (Activator.getInstance().isDebugging()) {
                    System.out.println("readEndianness() " + data);
                }
                drm.setData((Object)data);
                drm.done();
            }
        });
    }

    @Override
    public void getMemory(IMemory.IMemoryDMContext memoryDMC, IAddress address, long offset, int word_size, int word_count, DataRequestMonitor<MemoryByte[]> drm) {
        if (memoryDMC == null) {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.embedcdt.debug.gdbjtag.core", 10005, "Unknown context type", null));
            drm.done();
            return;
        }
        if (word_size < 1) {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.embedcdt.debug.gdbjtag.core", 10003, "Word size not supported (< 1)", null));
            drm.done();
            return;
        }
        if (word_count < 0) {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.embedcdt.debug.gdbjtag.core", 10005, "Invalid word count (< 0)", null));
            drm.done();
            return;
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println(String.format("readMemoryBlock 0x%s+0x%X 0x%X", address.toString(16), offset, word_count * word_size));
        }
        this.flushCache((IDMContext)memoryDMC);
        this.readMemoryBlock((IDMContext)memoryDMC, address, offset, 1, word_count * word_size, drm);
    }

    @Override
    public void setMemory(IMemory.IMemoryDMContext memoryDMC, IAddress address, long offset, int word_size, int word_count, byte[] buffer, RequestMonitor rm) {
        if (memoryDMC == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.embedcdt.debug.gdbjtag.core", 10005, "Unknown context type", null));
            rm.done();
            return;
        }
        if (word_size < 1) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.embedcdt.debug.gdbjtag.core", 10003, "Word size not supported (< 1)", null));
            rm.done();
            return;
        }
        if (word_count < 0) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.embedcdt.debug.gdbjtag.core", 10005, "Invalid word count (< 0)", null));
            rm.done();
            return;
        }
        if (buffer.length < word_count * word_size) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.embedcdt.debug.gdbjtag.core", 10005, "Buffer too short", null));
            rm.done();
            return;
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println(String.format("writeMemoryBlock 0x%s+0x%X 0x%X", address.toString(16), offset, word_count * word_size));
        }
        this.flushCache((IDMContext)memoryDMC);
        this.writeMemoryBlock((IDMContext)memoryDMC, address, offset, 1, word_count * word_size, buffer, rm);
    }

    private class PeripheralSequence
    extends Sequence {
        private String fOriginalLanguage;
        private boolean fAbortLanguageSteps;
        IMemory.IMemoryDMContext fMemContext;
        private Sequence.Step[] fSteps;

        public PeripheralSequence(IMemory.IMemoryDMContext memContext, DsfExecutor executor, RequestMonitor rm) {
            super(executor, rm);
            this.fOriginalLanguage = "auto";
            this.fAbortLanguageSteps = false;
            this.fSteps = null;
            if (Activator.getInstance().isDebugging()) {
                System.out.println("PeripheralSequence() " + memContext.getSessionId());
            }
            this.fMemContext = memContext;
        }

        public Sequence.Step[] getSteps() {
            if (this.fSteps == null) {
                this.fSteps = this.prepareSteps();
            }
            return this.fSteps;
        }

        private void stepShowLanguage(final RequestMonitor requestMonitor) {
            PeripheralMemoryService.this.fCommandControl.queueCommand(PeripheralMemoryService.this.fCommandControl.getCommandFactory().createMIGDBShowLanguage((IDMContext)this.fMemContext), (DataRequestMonitor)new ImmediateDataRequestMonitor<MIGDBShowLanguageInfo>(requestMonitor){

                protected void handleCompleted() {
                    if (this.isSuccess()) {
                        PeripheralSequence.this.fOriginalLanguage = ((MIGDBShowLanguageInfo)this.getData()).getLanguage();
                    } else {
                        PeripheralSequence.this.fAbortLanguageSteps = true;
                    }
                    requestMonitor.done();
                }
            });
        }

        private void stepReadAddressSize(final RequestMonitor requestMonitor) {
            PeripheralMemoryService.this.readAddressSize(this.fMemContext, (DataRequestMonitor<Integer>)new ImmediateDataRequestMonitor<Integer>(requestMonitor){

                protected void handleCompleted() {
                    if (this.isSuccess()) {
                        ((PeripheralSequence)PeripheralSequence.this).PeripheralMemoryService.this.fAddressSize = (Integer)this.getData();
                    }
                    requestMonitor.done();
                }
            });
        }

        private void stepSetLanguage(final RequestMonitor requestMonitor) {
            if (this.fAbortLanguageSteps) {
                requestMonitor.done();
                return;
            }
            PeripheralMemoryService.this.fCommandControl.queueCommand(PeripheralMemoryService.this.fCommandControl.getCommandFactory().createMIGDBSetLanguage((IDMContext)this.fMemContext, this.fOriginalLanguage), (DataRequestMonitor)new ImmediateDataRequestMonitor<MIInfo>(requestMonitor){

                protected void handleCompleted() {
                    if (!this.isSuccess()) {
                        Activator.log((IStatus)this.getStatus());
                        ((PeripheralSequence)PeripheralSequence.this).PeripheralMemoryService.this.fCommandControl.queueCommand(((PeripheralSequence)PeripheralSequence.this).PeripheralMemoryService.this.fCommandControl.getCommandFactory().createMIGDBSetLanguage((IDMContext)PeripheralSequence.this.fMemContext, "auto"), (DataRequestMonitor)new ImmediateDataRequestMonitor<MIInfo>(requestMonitor){

                            protected void handleCompleted() {
                                if (!this.isSuccess()) {
                                    Activator.log((IStatus)this.getStatus());
                                }
                                requestMonitor.done();
                            }
                        });
                    } else {
                        requestMonitor.done();
                    }
                }
            });
        }

        private void stepReadEndianess(final RequestMonitor requestMonitor) {
            PeripheralMemoryService.this.readEndianness(this.fMemContext, (DataRequestMonitor<Boolean>)new ImmediateDataRequestMonitor<Boolean>(requestMonitor){

                protected void handleCompleted() {
                    if (this.isSuccess()) {
                        ((PeripheralSequence)PeripheralSequence.this).PeripheralMemoryService.this.fIsBigEndian = (Boolean)this.getData();
                    }
                    requestMonitor.done();
                }
            });
        }

        private Sequence.Step[] prepareSteps() {
            ArrayList<Sequence.Step> stepsList = new ArrayList<Sequence.Step>();
            if (PeripheralMemoryService.this.fAddressSize == null) {
                stepsList.add(new Sequence.Step(){

                    public void execute(RequestMonitor requestMonitor) {
                        PeripheralSequence.this.stepShowLanguage(requestMonitor);
                    }
                });
                stepsList.add(new Sequence.Step(){

                    public void execute(RequestMonitor requestMonitor) {
                        PeripheralSequence.this.stepReadAddressSize(requestMonitor);
                    }
                });
                stepsList.add(new Sequence.Step(){

                    public void execute(RequestMonitor requestMonitor) {
                        PeripheralSequence.this.stepSetLanguage(requestMonitor);
                    }
                });
            }
            if (PeripheralMemoryService.this.fIsBigEndian == null) {
                stepsList.add(new Sequence.Step(){

                    public void execute(RequestMonitor requestMonitor) {
                        PeripheralSequence.this.stepReadEndianess(requestMonitor);
                    }
                });
            }
            if (Activator.getInstance().isDebugging()) {
                System.out.println("PeripheralSequence has " + stepsList.size() + " steps.");
            }
            return stepsList.toArray(new Sequence.Step[stepsList.size()]);
        }
    }
}

