/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.ui;

import org.eclipse.core.runtime.IPath;
import org.eclipse.embedcdt.core.XpackUtils;
import org.eclipse.embedcdt.ui.DirectoryNotStrictFieldEditor;
import org.eclipse.embedcdt.ui.XpackBrowseDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class XpackDirectoryNotStrictFieldEditor
extends DirectoryNotStrictFieldEditor {
    protected String[] fXpackNames;
    protected Button fXpackButton;
    protected String[] fVersions;

    public XpackDirectoryNotStrictFieldEditor(String[] xpackNames, String buildToolsPathKey, String toolsPaths_label, Composite fieldEditorParent, boolean isStrict) {
        super(buildToolsPathKey, toolsPaths_label, fieldEditorParent, isStrict);
        assert (xpackNames != null);
        this.fXpackNames = xpackNames;
        this.fVersions = XpackUtils.getPackVersions((String[])this.fXpackNames);
        if (this.fVersions.length > 0) {
            String[] stringArray = xpackNames;
            int n = xpackNames.length;
            int n2 = 0;
            while (n2 < n) {
                String xpackName = stringArray[n2];
                IPath packPath = XpackUtils.getPackPath((String)xpackName);
                if (packPath.toFile().isDirectory()) {
                    this.fXpackButton.setEnabled(true);
                    break;
                }
                packPath = XpackUtils.getSysPackPath((String)xpackName);
                if (packPath.toFile().isDirectory()) {
                    this.fXpackButton.setEnabled(true);
                    break;
                }
                ++n2;
            }
        }
    }

    public int getNumberOfControls() {
        return 4;
    }

    public void adjustForNumColumns(int numColumns) {
        super.adjustForNumColumns(numColumns - 1);
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        super.doFillIntoGrid(parent, numColumns - 1);
        this.fXpackButton = new Button(parent, 8);
        this.fXpackButton.setText("xPack...");
        this.fXpackButton.setFont(parent.getFont());
        this.fXpackButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                XpackDirectoryNotStrictFieldEditor.this.buttonPressed(event);
            }
        });
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        int widthHint = this.convertHorizontalDLUsToPixels((Control)this.fXpackButton, 61);
        gd.widthHint = Math.max(widthHint, this.fXpackButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.fXpackButton.setLayoutData((Object)gd);
        this.fXpackButton.setEnabled(false);
    }

    private void buttonPressed(SelectionEvent e) {
        XpackBrowseDialog dlg = new XpackBrowseDialog(this.getShell(), this.fVersions);
        if (dlg.open() == 0) {
            int index = dlg.getData();
            String version = this.fVersions[index];
            String[] stringArray = this.fXpackNames;
            int n = this.fXpackNames.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                IPath path = XpackUtils.getPackPath((String)name).append(version);
                if (path.toFile().isDirectory() || (path = XpackUtils.getSysPackPath((String)name).append(version)).toFile().isDirectory()) {
                    path = path.append(".content").append("bin");
                    this.setStringValue(path.toString());
                    break;
                }
                ++n2;
            }
        }
    }
}

