/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.templates.core.processes;

import java.util.List;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.cdt.core.templateengine.process.processes.Messages;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.embedcdt.templates.core.Utils;

public class AppendToMBSStringListOptionValues
extends ProcessRunner {
    public void process(TemplateCore template, ProcessArgument[] args, String processId, IProgressMonitor monitor) throws ProcessFailureException {
        String projectName = args[0].getSimpleValue();
        IProject projectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription workspaceDesc = workspace.getDescription();
        boolean autoBuilding = workspaceDesc.isAutoBuilding();
        workspaceDesc.setAutoBuilding(false);
        try {
            workspace.setDescription(workspaceDesc);
        }
        catch (CoreException coreException) {}
        ProcessArgument[][] resourcePathObjects = args[1].getComplexArrayValue();
        boolean modified = false;
        ProcessArgument[][] processArgumentArray = resourcePathObjects;
        int n = resourcePathObjects.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessArgument[] resourcePathObject = processArgumentArray[n2];
            String id = resourcePathObject[0].getSimpleValue();
            String[] values = resourcePathObject[1].getSimpleArrayValue();
            String path = resourcePathObject[2].getSimpleValue();
            String buildType = resourcePathObject[3].getSimpleValue();
            try {
                modified |= this.setOptionValue(projectHandle, id, values, path, buildType);
            }
            catch (BuildException e) {
                throw new ProcessFailureException(String.valueOf(Messages.getString((String)"AppendToMBSStringListOptionValues.0")) + e.getMessage(), (Throwable)e);
            }
            ++n2;
        }
        if (modified) {
            ManagedBuildManager.saveBuildInfo((IProject)projectHandle, (boolean)true);
        }
        workspaceDesc.setAutoBuilding(autoBuilding);
        try {
            workspace.setDescription(workspaceDesc);
        }
        catch (CoreException coreException) {}
    }

    private boolean setOptionValue(IProject projectHandle, String id, String[] value, String path, String buildType) throws BuildException, ProcessFailureException {
        IConfiguration[] projectConfigs = ManagedBuildManager.getBuildInfo((IResource)projectHandle).getManagedProject().getConfigurations();
        boolean resource = path != null && !path.equals("") && !path.equals("/");
        boolean modified = false;
        IConfiguration[] iConfigurationArray = projectConfigs;
        int n = projectConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration config = iConfigurationArray[n2];
            if (Utils.isBuildType(config, buildType)) {
                int n3;
                IResourceConfiguration resourceConfig = null;
                if (resource) {
                    ITool[] tools;
                    resourceConfig = config.getResourceConfiguration(path);
                    if (resourceConfig == null) {
                        IFile file = projectHandle.getFile(path);
                        if (file == null) {
                            throw new ProcessFailureException(String.valueOf(Messages.getString((String)"AppendToMBSStringListOptionValues.3")) + path);
                        }
                        resourceConfig = config.createResourceConfiguration(file);
                    }
                    ITool[] iToolArray = tools = resourceConfig.getTools();
                    n3 = tools.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ITool tool = iToolArray[n4];
                        modified |= this.setOptionForResourceConfig(id, value, resourceConfig, tool.getOptions(), (IHoldsOptions)tool);
                        ++n4;
                    }
                } else {
                    ITool[] tools;
                    IToolChain toolChain = config.getToolChain();
                    modified |= this.setOptionForConfig(id, value, config, toolChain.getOptions(), (IHoldsOptions)toolChain);
                    ITool[] iToolArray = tools = config.getTools();
                    int n5 = tools.length;
                    n3 = 0;
                    while (n3 < n5) {
                        ITool tool = iToolArray[n3];
                        modified |= this.setOptionForConfig(id, value, config, tool.getOptions(), (IHoldsOptions)tool);
                        ++n3;
                    }
                }
            }
            ++n2;
        }
        return modified;
    }

    private boolean setOptionForResourceConfig(String id, String[] value, IResourceConfiguration resourceConfig, IOption[] options, IHoldsOptions optionHolder) throws BuildException {
        boolean modified = false;
        String lowerId = id.toLowerCase();
        IOption[] iOptionArray = options;
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            IOption option = iOptionArray[n2];
            if (option.getBaseId().toLowerCase().matches(lowerId)) {
                switch (option.getValueType()) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        List list = (List)option.getValue();
                        String[] newValue = AppendToMBSStringListOptionValues.concat(list.toArray(new String[list.size()]), value);
                        ManagedBuildManager.setOption((IResourceInfo)resourceConfig, (IHoldsOptions)optionHolder, (IOption)option, (String[])newValue);
                        modified = true;
                    }
                }
            }
            ++n2;
        }
        return modified;
    }

    private boolean setOptionForConfig(String id, String[] value, IConfiguration config, IOption[] options, IHoldsOptions optionHolder) throws BuildException {
        boolean modified = false;
        String lowerId = id.toLowerCase();
        IOption[] iOptionArray = options;
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            IOption option = iOptionArray[n2];
            if (option.getBaseId().toLowerCase().matches(lowerId)) {
                switch (option.getValueType()) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        List list = (List)option.getValue();
                        String[] newValue = AppendToMBSStringListOptionValues.concat(list.toArray(new String[list.size()]), value);
                        ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)optionHolder, (IOption)option, (String[])newValue);
                        modified = true;
                    }
                }
            }
            ++n2;
        }
        return modified;
    }

    private static String[] concat(String[] a, String[] b) {
        String[] result = new String[a.length + b.length];
        System.arraycopy(a, 0, result, 0, a.length);
        System.arraycopy(b, 0, result, a.length, b.length);
        return result;
    }
}

