/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.vertiflex.options;

import java.util.EnumSet;
import org.eclipse.elk.alg.vertiflex.EdgeRoutingStrategy;
import org.eclipse.elk.alg.vertiflex.options.VertiFlexOptions;
import org.eclipse.elk.core.data.ILayoutMetaDataProvider;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.Property;

public class VertiFlexMetaDataProvider
implements ILayoutMetaDataProvider {
    public static final IProperty<Double> VERTICAL_CONSTRAINT = new Property("org.eclipse.elk.vertiflex.verticalConstraint");
    private static final EdgeRoutingStrategy LAYOUT_STRATEGY_DEFAULT = EdgeRoutingStrategy.STRAIGHT;
    public static final IProperty<EdgeRoutingStrategy> LAYOUT_STRATEGY = new Property("org.eclipse.elk.vertiflex.layoutStrategy", (Object)LAYOUT_STRATEGY_DEFAULT, null, null);
    private static final double LAYER_DISTANCE_DEFAULT = 50.0;
    public static final IProperty<Double> LAYER_DISTANCE = new Property("org.eclipse.elk.vertiflex.layerDistance", (Object)50.0, null, null);
    private static final boolean CONSIDER_NODE_MODEL_ORDER_DEFAULT = true;
    public static final IProperty<Boolean> CONSIDER_NODE_MODEL_ORDER = new Property("org.eclipse.elk.vertiflex.considerNodeModelOrder", (Object)true, null, null);

    public void apply(ILayoutMetaDataProvider.Registry registry) {
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.vertiflex.verticalConstraint").group("").name("Fixed vertical position").description("The Y position that the node should be fixed at.").type(LayoutOptionData.Type.DOUBLE).optionClass(Double.class).targets(EnumSet.of(LayoutOptionData.Target.NODES)).visibility(LayoutOptionData.Visibility.VISIBLE).create());
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.vertiflex.layoutStrategy").group("").name("Edge layout strategy").description("Strategy for the layout of the children. 'straight' for straight line drawings, 'bend' for a possible bend. When straight edges are prioritized the nodes will be reordered in order to guarantee that straight edges are possible. If bend points are enabled on the other hand, the given model order of the nodes is maintained and bend points are introduced to prevent edge node overlaps.").defaultValue((Object)LAYOUT_STRATEGY_DEFAULT).type(LayoutOptionData.Type.ENUM).optionClass(EdgeRoutingStrategy.class).targets(EnumSet.of(LayoutOptionData.Target.NODES)).visibility(LayoutOptionData.Visibility.VISIBLE).create());
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.vertiflex.layerDistance").group("").name("Layer distance").description("The distance to use between nodes of different layers if no vertical constraints are set.").defaultValue((Object)50.0).type(LayoutOptionData.Type.DOUBLE).optionClass(Double.class).targets(EnumSet.of(LayoutOptionData.Target.PARENTS)).visibility(LayoutOptionData.Visibility.VISIBLE).create());
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.vertiflex.considerNodeModelOrder").group("").name("Consider node model order").description("Consider node model as a secondary criterion when using straight line routing.").defaultValue((Object)true).type(LayoutOptionData.Type.BOOLEAN).optionClass(Boolean.class).targets(EnumSet.of(LayoutOptionData.Target.PARENTS)).visibility(LayoutOptionData.Visibility.VISIBLE).create());
        new VertiFlexOptions().apply(registry);
    }
}

