/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.gitflow.ui.internal.actions;

import java.io.IOException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IResource;
import org.eclipse.egit.gitflow.GitFlowRepository;
import org.eclipse.egit.ui.internal.selection.SelectionUtils;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.ui.handlers.HandlerUtil;

public class GitFlowHandlerUtil {
    @Nullable
    public static GitFlowRepository getRepository(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IStructuredSelection structuredSelection = SelectionUtils.getStructuredSelection((ISelection)selection);
        Repository repository = SelectionUtils.getRepository((IStructuredSelection)structuredSelection);
        if (repository == null) {
            return null;
        }
        return new GitFlowRepository(repository);
    }

    static IResource[] gatherResourceToOperateOn(ExecutionEvent event) {
        return GitFlowHandlerUtil.getSelectedResources(event);
    }

    static IResource[] getSelectedResources(ExecutionEvent event) {
        IStructuredSelection selection = GitFlowHandlerUtil.getSelection(event);
        return SelectionUtils.getSelectedResources((IStructuredSelection)selection);
    }

    static IStructuredSelection getSelection(ExecutionEvent event) {
        if (event == null) {
            throw new IllegalArgumentException("event must not be NULL");
        }
        Object context = event.getApplicationContext();
        if (context instanceof IEvaluationContext) {
            return SelectionUtils.getSelection((IEvaluationContext)((IEvaluationContext)context));
        }
        return StructuredSelection.EMPTY;
    }

    static String gatherRevision(ExecutionEvent event) throws IOException {
        GitFlowRepository gfRepo = GitFlowHandlerUtil.getRepository(event);
        if (gfRepo == null) {
            throw new IllegalStateException("Gitflow command called with no Gitflow repository present");
        }
        Ref develop = gfRepo.getRepository().exactRef(gfRepo.getConfig().getDevelopFull());
        if (develop == null) {
            throw new IllegalStateException("Gitflow command called on Gitflow repository with no develop branch. The Gitflow configuration is either corrupt or incomplete.");
        }
        return develop.getName();
    }
}

