/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.compare;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.egerrit.internal.model.CommentInfo;
import org.eclipse.egerrit.internal.model.ModelFactory;
import org.eclipse.egerrit.internal.ui.compare.CommentPrettyPrinter;
import org.eclipse.egerrit.internal.ui.compare.GerritCommentAnnotation;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;

public class CommentExtractor {
    private AnnotationModel originalCommentsModel;
    private ArrayList<GerritCommentAnnotation> originalComments;
    private IDocument newDocument;
    private AnnotationModel newCommentsModel;
    private ArrayList<GerritCommentAnnotation> newComments;
    private int numberOfRemovedLines = 0;
    private ArrayList<CommentInfo> addedComments = new ArrayList();
    private ArrayList<CommentInfo> modifiedComments = new ArrayList();
    private ArrayList<CommentInfo> removedComments = new ArrayList();
    private IDocument originalDocument;

    public void extractComments(IDocument documentWithOriginalComments, AnnotationModel originalCommentsModel, IDocument documentWithNewComments, AnnotationModel commentsModelWithNewComments) {
        if (documentWithOriginalComments.get().equals(documentWithNewComments.get())) {
            return;
        }
        this.originalCommentsModel = originalCommentsModel;
        this.originalComments = CommentExtractor.toAnnotationList(originalCommentsModel, documentWithOriginalComments);
        this.newDocument = documentWithNewComments;
        this.originalDocument = documentWithOriginalComments;
        this.newCommentsModel = commentsModelWithNewComments;
        this.newComments = CommentExtractor.toAnnotationList(commentsModelWithNewComments, documentWithNewComments);
        for (GerritCommentAnnotation newComment : this.newComments) {
            GerritCommentAnnotation match = null;
            if (newComment.getComment() == null) {
                this.createNewComment(newComment);
                continue;
            }
            match = this.wasPresentButModified(newComment);
            if (match != null) {
                this.originalComments.remove((Object)match);
                this.handleModifiedComment(newComment, match);
                continue;
            }
            match = this.wasPresentAndUnmodified(newComment);
            if (match == null) continue;
            this.numberOfRemovedLines += this.numberOfLines(newComment);
            this.originalComments.remove((Object)match);
        }
        this.handleOldComments();
    }

    private void handleModifiedComment(GerritCommentAnnotation newComment, GerritCommentAnnotation match) {
        this.numberOfRemovedLines += this.numberOfLines(newComment);
        if (CommentExtractor.extractCommentMessage(this.originalDocument, this.originalCommentsModel, match).equals(CommentExtractor.extractCommentMessage(this.newDocument, this.newCommentsModel, newComment))) {
            return;
        }
        this.modifiedComments.add(this.modifyComment(newComment));
    }

    private void handleOldComments() {
        for (GerritCommentAnnotation comment : this.originalComments) {
            this.removedComments.add(comment.getComment());
        }
    }

    private CommentInfo modifyComment(GerritCommentAnnotation comment) {
        CommentInfo infoToModify = comment.getComment();
        infoToModify.setMessage(this.extractModifiedComment(comment));
        return infoToModify;
    }

    private String extractModifiedComment(GerritCommentAnnotation newComment) {
        int dateIdx;
        String comment = CommentExtractor.extractCommentMessage(this.newDocument, this.newCommentsModel, newComment);
        String name = CommentPrettyPrinter.printName(newComment.getComment());
        String date = CommentPrettyPrinter.printDate(newComment.getComment());
        if (comment.startsWith(name)) {
            comment = comment.substring(name.length());
        }
        if ((dateIdx = comment.lastIndexOf(date)) > 0) {
            if (dateIdx + date.length() + 1 == comment.length()) {
                comment = comment.substring(0, dateIdx);
            } else {
                String end = comment.substring(dateIdx + date.length());
                comment = String.valueOf(comment.substring(0, dateIdx)) + end;
            }
        }
        return comment.trim();
    }

    private void createNewComment(GerritCommentAnnotation newComment) {
        int lineCommented = this.getLineNumber(newComment) - this.numberOfRemovedLines;
        String comment = CommentExtractor.extractCommentMessage(this.newDocument, this.newCommentsModel, newComment);
        this.numberOfRemovedLines += this.newDocument.computeNumberOfLines(comment) + 1;
        if (comment.trim().length() == 0) {
            return;
        }
        if (lineCommented > 0) {
            GerritCommentAnnotation commentRepliedTo = this.isAnswerToExistingComment(lineCommented);
            if (commentRepliedTo == null) {
                this.addedComments.add(this.newComment(comment, lineCommented));
            } else {
                this.addedComments.add(this.newComment(comment, commentRepliedTo));
            }
        } else {
            this.addedComments.add(this.newComment(comment, 0));
        }
    }

    private int getLineNumber(GerritCommentAnnotation newComment) {
        Position commentPosition = this.newCommentsModel.getPosition((Annotation)newComment);
        try {
            return this.newDocument.getLineOfOffset(commentPosition.getOffset());
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    private int numberOfLines(GerritCommentAnnotation comment) {
        return this.newDocument.computeNumberOfLines(CommentExtractor.extractCommentMessage(this.newDocument, this.newCommentsModel, comment)) + 1;
    }

    private static ArrayList<GerritCommentAnnotation> toAnnotationList(AnnotationModel commentsModel, IDocument associatedDocument) {
        ArrayList<GerritCommentAnnotation> sortedComments = new ArrayList<GerritCommentAnnotation>();
        try {
            Position[] positions;
            Position[] positionArray = positions = associatedDocument.getPositions("__dflt_position_category");
            int n = positions.length;
            int n2 = 0;
            while (n2 < n) {
                Position position = positionArray[n2];
                Iterator match = commentsModel.getAnnotationIterator(position.getOffset(), position.getLength(), false, false);
                if (match.hasNext()) {
                    sortedComments.add((GerritCommentAnnotation)((Object)match.next()));
                }
                ++n2;
            }
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
        return sortedComments;
    }

    private GerritCommentAnnotation wasPresentAndUnmodified(GerritCommentAnnotation newComment) {
        if (newComment.getComment() == null) {
            return null;
        }
        Iterator it = this.originalCommentsModel.getAnnotationIterator();
        Position positionNewComment = this.newCommentsModel.getPosition((Annotation)newComment);
        while (it.hasNext()) {
            GerritCommentAnnotation object = (GerritCommentAnnotation)((Object)it.next());
            Position positingExistingComment = this.originalCommentsModel.getPosition((Annotation)object);
            if (!object.getComment().equals(newComment.getComment()) || !positingExistingComment.equals((Object)positionNewComment)) continue;
            return object;
        }
        return null;
    }

    private GerritCommentAnnotation wasPresentButModified(GerritCommentAnnotation newComment) {
        if (newComment.getComment() == null) {
            return null;
        }
        for (GerritCommentAnnotation commentInfo : this.originalComments) {
            if (!commentInfo.getComment().getId().equals(newComment.getComment().getId())) continue;
            return commentInfo;
        }
        return null;
    }

    public ArrayList<CommentInfo> getAddedComments() {
        return this.addedComments;
    }

    public ArrayList<CommentInfo> getModifiedComments() {
        return this.modifiedComments;
    }

    public ArrayList<CommentInfo> getRemovedComments() {
        return this.removedComments;
    }

    private boolean isDone(GerritCommentAnnotation comment) {
        if (comment == null) {
            return false;
        }
        return comment.getComment().getMessage().equalsIgnoreCase("done");
    }

    private CommentInfo newComment(String comment, GerritCommentAnnotation replyTo) {
        CommentInfo info = ModelFactory.eINSTANCE.createCommentInfo();
        info.setLine(replyTo.getComment().getLine());
        info.setMessage(comment);
        info.setPath(replyTo.getComment().getPath());
        info.setInReplyTo(replyTo.getComment().getId());
        return info;
    }

    private CommentInfo newComment(String comment, int line) {
        CommentInfo info = ModelFactory.eINSTANCE.createCommentInfo();
        info.setLine(line);
        info.setMessage(comment);
        return info;
    }

    private GerritCommentAnnotation isAnswerToExistingComment(int line) {
        GerritCommentAnnotation match = null;
        for (GerritCommentAnnotation comment : this.newComments) {
            if (comment.getComment() == null || comment.getComment().getLine() != line || comment.getComment().getAuthor() == null) continue;
            if (this.isDone(comment)) {
                if (match == null || !match.getComment().getId().equals(comment.getComment().getInReplyTo())) continue;
                match = null;
                continue;
            }
            match = comment;
        }
        return match;
    }

    private static String extractCommentMessage(IDocument document, AnnotationModel annotationModel, GerritCommentAnnotation commentAnnotation) {
        Position position = annotationModel.getPosition((Annotation)commentAnnotation);
        try {
            return document.get(position.offset, position.length);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }
}

