/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.process;

import java.util.concurrent.CompletableFuture;
import org.eclipse.egerrit.internal.core.EGerritCorePlugin;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.core.command.RebaseRevisionCommand;
import org.eclipse.egerrit.internal.core.exception.EGerritException;
import org.eclipse.egerrit.internal.core.rest.RebaseInput;
import org.eclipse.egerrit.internal.model.ChangeInfo;
import org.eclipse.egerrit.internal.model.ModelPackage;
import org.eclipse.egerrit.internal.model.RevisionInfo;
import org.eclipse.egerrit.internal.ui.editors.QueryHelpers;
import org.eclipse.egerrit.internal.ui.editors.RefreshRelatedEditors;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class RebaseProcess {
    public void handleRebase(Shell shell, final ChangeInfo changeInfo, final RevisionInfo toRebase, final GerritClient gerritClient) {
        InputDialog inputDialog = new InputDialog(shell, Messages.RebaseProcess_title, Messages.RebaseProcess_changeParent, "", null){

            protected void createButtonsForButtonBar(Composite parent) {
                super.createButtonsForButtonBar(parent);
                this.getText().addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        if (!toRebase.isRebaseable()) {
                            if (!this.getText().getText().isEmpty()) {
                                this.getOkButton().setEnabled(true);
                            } else {
                                this.getOkButton().setEnabled(false);
                                this.getOkButton().getParent().setToolTipText(toRebase.isRebaseable() ? "" : Messages.RebaseProcess_changeIsAlreadyUpToDate);
                            }
                        }
                    }
                });
                this.getOkButton().setEnabled(toRebase.isRebaseable());
                this.getOkButton().getParent().setToolTipText(toRebase.isRebaseable() ? "" : Messages.RebaseProcess_changeIsAlreadyUpToDate);
            }
        };
        if (inputDialog.open() != 0) {
            return;
        }
        RebaseRevisionCommand rebaseCmd = gerritClient.rebase(changeInfo.getId(), toRebase.getId());
        RebaseInput rebaseInput = new RebaseInput();
        rebaseInput.setBase(inputDialog.getValue().trim().length() == 0 ? null : inputDialog.getValue().trim());
        rebaseCmd.setCommandInput((Object)rebaseInput);
        CompletableFuture.runAsync(() -> {
            changeInfo.eAdapters().add((Object)new EContentAdapter(){

                public void notifyChanged(Notification msg) {
                    if (msg.getFeature() == null) {
                        return;
                    }
                    if (msg.getFeature().equals(ModelPackage.Literals.CHANGE_INFO__RELATED_CHANGES) && msg.getEventType() == 1) {
                        new RefreshRelatedEditors(changeInfo, gerritClient).schedule();
                        changeInfo.eAdapters().remove((Object)this);
                    }
                }
            });
            try {
                rebaseCmd.call();
            }
            catch (EGerritException e) {
                if (e.getCode() == 1) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.open((int)2, null, (String)Messages.RebaseProcess_failed, (String)Messages.RebaseProcess_notPerform, (int)0);
                        }
                    });
                }
                EGerritCorePlugin.logError((String)(String.valueOf(gerritClient.getRepository().formatGerritVersion()) + e.getMessage()));
            }
        }).thenRun(() -> {
            QueryHelpers.loadBasicInformation(gerritClient, changeInfo, true);
            changeInfo.setUserSelectedRevision(changeInfo.getRevision());
        });
    }
}

