/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.ui.wizards;

import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.fx.ide.ui.wizards.AbstractJDTElementPage;
import org.eclipse.fx.ide.ui.wizards.template.JDTElement;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.ui.JavaElementComparator;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class JDTElementFactory {
    public static void createSourceFolderElement(final Composite parent, DataBindingContext dbc, final JDTElement clazz, final IWorkspaceRoot fWorkspaceRoot) {
        Label l = new Label(parent, 0);
        l.setText("Source folder");
        Text t = new Text(parent, 2048);
        t.setLayoutData((Object)new GridData(768));
        t.setEditable(false);
        final Binding bd = dbc.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)t), BeanProperties.value((String)"fragmentRoot").observe((Object)clazz), new UpdateValueStrategy(), new UpdateValueStrategy().setConverter((IConverter)new AbstractJDTElementPage.PackageFragmentRootToStringConverter()));
        Button b = new Button(parent, 8);
        b.setText("Browse ...");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPackageFragmentRoot root = JDTElementFactory.choosePackageRoot(parent.getShell(), clazz, fWorkspaceRoot);
                if (root != null) {
                    clazz.setFragmentRoot(root);
                }
                bd.updateModelToTarget();
            }
        });
    }

    public static void createPackageElement(final Composite parent, DataBindingContext dbc, final JDTElement clazz) {
        Label l = new Label(parent, 0);
        l.setText("Package");
        Text t = new Text(parent, 2048);
        t.setEditable(false);
        t.setLayoutData((Object)new GridData(768));
        final Binding bd = dbc.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)t), BeanProperties.value((String)"packageFragment").observe((Object)clazz), new UpdateValueStrategy(), new UpdateValueStrategy().setConverter((IConverter)new AbstractJDTElementPage.PackageFragmentToStringConverter()));
        Button b = new Button(parent, 8);
        b.setText("Browse ...");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPackageFragment fragment = JDTElementFactory.choosePackage(parent.getShell(), clazz);
                if (fragment != null) {
                    clazz.setPackageFragment(fragment);
                }
                bd.updateModelToTarget();
            }
        });
    }

    private static IPackageFragment choosePackage(Shell s, JDTElement clazz) {
        Object[] packages = null;
        try {
            if (clazz.getFragmentRoot() != null && clazz.getFragmentRoot().exists()) {
                packages = clazz.getFragmentRoot().getChildren();
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        if (packages == null) {
            packages = new IJavaElement[]{};
        }
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(s, (ILabelProvider)new JavaElementLabelProvider(18));
        dialog.setIgnoreCase(false);
        dialog.setTitle("Choose Package");
        dialog.setMessage("Choose a Package");
        dialog.setEmptyListMessage("You need to select a package");
        dialog.setElements(packages);
        dialog.setHelpAvailable(false);
        IPackageFragment pack = clazz.getPackageFragment();
        if (pack != null) {
            dialog.setInitialSelections(new Object[]{pack});
        }
        if (dialog.open() == 0) {
            return (IPackageFragment)dialog.getFirstResult();
        }
        return null;
    }

    private static IPackageFragmentRoot choosePackageRoot(Shell shell, JDTElement clazz, IWorkspaceRoot fWorkspaceRoot) {
        IPackageFragmentRoot initElement = clazz.getFragmentRoot();
        Class[] acceptedClasses = new Class[]{IPackageFragmentRoot.class, IJavaProject.class};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false){

            public boolean isSelectedValid(Object element) {
                try {
                    if (element instanceof IJavaProject) {
                        IJavaProject jproject = (IJavaProject)element;
                        IPath path = jproject.getProject().getFullPath();
                        return jproject.findPackageFragmentRoot(path) != null;
                    }
                    if (element instanceof IPackageFragmentRoot) {
                        return ((IPackageFragmentRoot)element).getKind() == 1;
                    }
                    return true;
                }
                catch (JavaModelException e) {
                    JavaPlugin.log((IStatus)e.getStatus());
                    return false;
                }
            }
        };
        acceptedClasses = new Class[]{IJavaModel.class, IPackageFragmentRoot.class, IJavaProject.class};
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses){

            public boolean select(Viewer viewer, Object parent, Object element) {
                if (element instanceof IPackageFragmentRoot) {
                    try {
                        return ((IPackageFragmentRoot)element).getKind() == 1;
                    }
                    catch (JavaModelException e) {
                        JavaPlugin.log((IStatus)e.getStatus());
                        return false;
                    }
                }
                return super.select(viewer, parent, element);
            }
        };
        StandardJavaElementContentProvider provider = new StandardJavaElementContentProvider();
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(18);
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)labelProvider, (ITreeContentProvider)provider);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setComparator((ViewerComparator)new JavaElementComparator());
        dialog.setTitle(NewWizardMessages.NewContainerWizardPage_ChooseSourceContainerDialog_title);
        dialog.setMessage(NewWizardMessages.NewContainerWizardPage_ChooseSourceContainerDialog_description);
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)JavaCore.create((IWorkspaceRoot)fWorkspaceRoot));
        dialog.setInitialSelection((Object)initElement);
        dialog.setHelpAvailable(false);
        if (dialog.open() == 0) {
            Object element = dialog.getFirstResult();
            if (element instanceof IJavaProject) {
                IJavaProject jproject = (IJavaProject)element;
                return jproject.getPackageFragmentRoot((IResource)jproject.getProject());
            }
            if (element instanceof IPackageFragmentRoot) {
                return (IPackageFragmentRoot)element;
            }
            return null;
        }
        return null;
    }
}

