/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.dto.DTO;
import org.osgi.service.http.runtime.dto.ErrorPageDTO;
import org.osgi.service.http.runtime.dto.FailedFilterDTO;
import org.osgi.service.http.runtime.dto.FailedListenerDTO;
import org.osgi.service.http.runtime.dto.FailedResourceDTO;
import org.osgi.service.http.runtime.dto.FailedServletContextDTO;
import org.osgi.service.http.runtime.dto.FailedServletDTO;
import org.osgi.service.http.runtime.dto.FilterDTO;
import org.osgi.service.http.runtime.dto.ListenerDTO;
import org.osgi.service.http.runtime.dto.ResourceDTO;
import org.osgi.service.http.runtime.dto.ServletDTO;

public class DTOUtil {
    public static ErrorPageDTO clone(ErrorPageDTO original) {
        ErrorPageDTO clone = new ErrorPageDTO();
        clone.asyncSupported = DTOUtil.copy(original.asyncSupported);
        clone.errorCodes = DTOUtil.copy(original.errorCodes);
        clone.exceptions = DTOUtil.copy(original.exceptions);
        clone.initParams = DTOUtil.copyStringMap(original.initParams);
        clone.name = DTOUtil.copy(original.name);
        clone.serviceId = DTOUtil.copy(original.serviceId);
        clone.servletContextId = DTOUtil.copy(original.servletContextId);
        clone.servletInfo = DTOUtil.copy(original.servletInfo);
        return clone;
    }

    public static FailedFilterDTO clone(FailedFilterDTO original) {
        FailedFilterDTO clone = new FailedFilterDTO();
        clone.asyncSupported = DTOUtil.copy(original.asyncSupported);
        clone.dispatcher = DTOUtil.copy(original.dispatcher);
        clone.failureReason = DTOUtil.copy(original.failureReason);
        clone.initParams = DTOUtil.copyStringMap(original.initParams);
        clone.name = DTOUtil.copy(original.name);
        clone.patterns = DTOUtil.copy(original.patterns);
        clone.regexs = DTOUtil.copy(original.regexs);
        clone.serviceId = DTOUtil.copy(original.serviceId);
        clone.servletContextId = DTOUtil.copy(original.servletContextId);
        clone.servletNames = DTOUtil.copy(original.servletNames);
        return clone;
    }

    public static FailedListenerDTO clone(FailedListenerDTO original) {
        FailedListenerDTO clone = new FailedListenerDTO();
        clone.failureReason = DTOUtil.copy(original.failureReason);
        clone.serviceId = DTOUtil.copy(original.serviceId);
        clone.servletContextId = DTOUtil.copy(original.servletContextId);
        clone.types = DTOUtil.copy(original.types);
        return clone;
    }

    public static FailedResourceDTO clone(FailedResourceDTO original) {
        FailedResourceDTO clone = new FailedResourceDTO();
        clone.failureReason = DTOUtil.copy(original.failureReason);
        clone.patterns = DTOUtil.copy(original.patterns);
        clone.prefix = DTOUtil.copy(original.prefix);
        clone.serviceId = DTOUtil.copy(original.serviceId);
        clone.servletContextId = DTOUtil.copy(original.servletContextId);
        return clone;
    }

    public static FailedServletContextDTO clone(FailedServletContextDTO original) {
        FailedServletContextDTO clone = new FailedServletContextDTO();
        clone.attributes = DTOUtil.copyGenericMap(original.attributes);
        clone.contextPath = DTOUtil.copy(original.contextPath);
        clone.errorPageDTOs = DTOUtil.copy(original.errorPageDTOs);
        clone.failureReason = DTOUtil.copy(original.failureReason);
        clone.filterDTOs = DTOUtil.copy(original.filterDTOs);
        clone.initParams = DTOUtil.copyStringMap(original.initParams);
        clone.listenerDTOs = DTOUtil.copy(original.listenerDTOs);
        clone.name = DTOUtil.copy(original.name);
        clone.resourceDTOs = DTOUtil.copy(original.resourceDTOs);
        clone.serviceId = DTOUtil.copy(original.serviceId);
        clone.servletDTOs = DTOUtil.copy(original.servletDTOs);
        return clone;
    }

    public static FailedServletDTO clone(FailedServletDTO original) {
        FailedServletDTO clone = new FailedServletDTO();
        clone.asyncSupported = DTOUtil.copy(original.asyncSupported);
        clone.failureReason = DTOUtil.copy(original.failureReason);
        clone.initParams = DTOUtil.copyStringMap(clone.initParams);
        clone.name = DTOUtil.copy(original.name);
        clone.patterns = DTOUtil.copy(original.patterns);
        clone.serviceId = DTOUtil.copy(original.serviceId);
        clone.servletContextId = DTOUtil.copy(original.servletContextId);
        clone.servletInfo = DTOUtil.copy(original.servletInfo);
        return clone;
    }

    public static FilterDTO clone(FilterDTO original) {
        FilterDTO clone = new FilterDTO();
        clone.asyncSupported = DTOUtil.copy(original.asyncSupported);
        clone.dispatcher = DTOUtil.copy(original.dispatcher);
        clone.initParams = DTOUtil.copyStringMap(original.initParams);
        clone.name = DTOUtil.copy(original.name);
        clone.patterns = DTOUtil.copy(original.patterns);
        clone.regexs = DTOUtil.copy(original.regexs);
        clone.serviceId = DTOUtil.copy(original.serviceId);
        clone.servletContextId = DTOUtil.copy(original.servletContextId);
        clone.servletNames = DTOUtil.copy(original.servletNames);
        return clone;
    }

    public static ListenerDTO clone(ListenerDTO original) {
        ListenerDTO clone = new ListenerDTO();
        clone.serviceId = DTOUtil.copy(original.serviceId);
        clone.servletContextId = DTOUtil.copy(original.servletContextId);
        clone.types = DTOUtil.copy(original.types);
        return clone;
    }

    public static ResourceDTO clone(ResourceDTO original) {
        ResourceDTO clone = new ResourceDTO();
        clone.patterns = DTOUtil.copy(original.patterns);
        clone.prefix = DTOUtil.copy(original.prefix);
        clone.serviceId = DTOUtil.copy(original.serviceId);
        clone.servletContextId = DTOUtil.copy(original.servletContextId);
        return clone;
    }

    public static ServletDTO clone(ServletDTO original) {
        ServletDTO clone = new ServletDTO();
        clone.asyncSupported = DTOUtil.copy(original.asyncSupported);
        clone.initParams = DTOUtil.copyStringMap(original.initParams);
        clone.name = DTOUtil.copy(original.name);
        clone.patterns = DTOUtil.copy(original.patterns);
        clone.serviceId = DTOUtil.copy(original.serviceId);
        clone.servletContextId = DTOUtil.copy(original.servletContextId);
        clone.servletInfo = DTOUtil.copy(original.servletInfo);
        return clone;
    }

    private static long[] copy(long[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return array;
        }
        return Arrays.copyOf(array, array.length);
    }

    private static String[] copy(String[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return array;
        }
        return Arrays.copyOf(array, array.length);
    }

    private static <T> T[] copy(T[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return array;
        }
        return Arrays.copyOf(array, array.length);
    }

    private static int copy(int value) {
        return value;
    }

    private static long copy(long value) {
        return value;
    }

    private static boolean copy(boolean value) {
        return value;
    }

    private static String copy(String value) {
        return value;
    }

    private static Map<String, String> copyStringMap(Map<String, String> initParams) {
        return new HashMap<String, String>(initParams);
    }

    public static <V> Map<String, Object> copyGenericMap(Map<String, V> value) {
        if (value == null) {
            return null;
        }
        if (value.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, V> entry : value.entrySet()) {
            result.put(entry.getKey(), DTOUtil.mapValue(entry.getValue()));
        }
        return result;
    }

    public static Object mapValue(Object v) {
        if (v == null || v instanceof Number || v instanceof Boolean || v instanceof Character || v instanceof String || v instanceof DTO) {
            return v;
        }
        if (v instanceof Map) {
            Map m = (Map)v;
            Map<Object, Object> map = DTOUtil.newMap(m.size());
            for (Map.Entry e : m.entrySet()) {
                map.put(DTOUtil.mapValue(e.getKey()), DTOUtil.mapValue(e.getValue()));
            }
            return map;
        }
        if (v instanceof List) {
            List c = (List)v;
            List<Object> list = DTOUtil.newList(c.size());
            for (Object o : c) {
                list.add(DTOUtil.mapValue(o));
            }
            return list;
        }
        if (v instanceof Set) {
            Set c = (Set)v;
            Set<Object> set = DTOUtil.newSet(c.size());
            for (Object o : c) {
                set.add(DTOUtil.mapValue(o));
            }
            return set;
        }
        if (v.getClass().isArray()) {
            int length = Array.getLength(v);
            Class<?> componentType = DTOUtil.mapComponentType(v.getClass().getComponentType());
            Object array = Array.newInstance(componentType, length);
            int i = 0;
            while (i < length) {
                Array.set(array, i, DTOUtil.mapValue(Array.get(v, i)));
                ++i;
            }
            return array;
        }
        return String.valueOf(v);
    }

    private static Class<?> mapComponentType(Class<?> componentType) {
        if (componentType.isPrimitive() || componentType.isArray() || Object.class.equals(componentType) || Number.class.isAssignableFrom(componentType) || Boolean.class.isAssignableFrom(componentType) || Character.class.isAssignableFrom(componentType) || String.class.isAssignableFrom(componentType) || DTO.class.isAssignableFrom(componentType)) {
            return componentType;
        }
        if (Map.class.isAssignableFrom(componentType)) {
            return Map.class;
        }
        if (List.class.isAssignableFrom(componentType)) {
            return List.class;
        }
        if (Set.class.isAssignableFrom(componentType)) {
            return Set.class;
        }
        return String.class;
    }

    private static <E> List<E> newList(int size) {
        return new ArrayList(size);
    }

    private static <E> Set<E> newSet(int size) {
        return new HashSet(size);
    }

    private static <K, V> Map<K, V> newMap(int size) {
        return new HashMap(size);
    }
}

