/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.property.value;

import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.databinding.property.value.SimpleValueProperty;
import org.eclipse.core.databinding.property.value.ValueProperty;
import org.eclipse.core.internal.databinding.property.value.ListDelegatingValueObservableList;
import org.eclipse.core.internal.databinding.property.value.MapDelegatingValueObservableMap;
import org.eclipse.core.internal.databinding.property.value.SetDelegatingValueObservableMap;

public abstract class DelegatingValueProperty
extends ValueProperty {
    private final Object valueType;
    private final IValueProperty nullProperty = new NullValueProperty();

    protected DelegatingValueProperty() {
        this(null);
    }

    protected DelegatingValueProperty(Object valueType) {
        this.valueType = valueType;
    }

    public final IValueProperty getDelegate(Object source) {
        if (source == null) {
            return this.nullProperty;
        }
        IValueProperty delegate = this.doGetDelegate(source);
        if (delegate == null) {
            delegate = this.nullProperty;
        }
        return delegate;
    }

    protected abstract IValueProperty doGetDelegate(Object var1);

    @Override
    protected Object doGetValue(Object source) {
        return this.getDelegate(source).getValue(source);
    }

    @Override
    protected void doSetValue(Object source, Object value) {
        this.getDelegate(source).setValue(source, value);
    }

    @Override
    public Object getValueType() {
        return this.valueType;
    }

    @Override
    public IObservableValue observe(Object source) {
        return this.getDelegate(source).observe(source);
    }

    @Override
    public IObservableValue observe(Realm realm, Object source) {
        return this.getDelegate(source).observe(realm, source);
    }

    @Override
    public IObservableList observeDetail(IObservableList master) {
        return new ListDelegatingValueObservableList(master, this);
    }

    @Override
    public IObservableMap observeDetail(IObservableSet master) {
        return new SetDelegatingValueObservableMap(master, this);
    }

    @Override
    public IObservableMap observeDetail(IObservableMap master) {
        return new MapDelegatingValueObservableMap(master, this);
    }

    private class NullValueProperty
    extends SimpleValueProperty {
        private NullValueProperty() {
        }

        @Override
        public Object getValueType() {
            return DelegatingValueProperty.this.valueType;
        }

        @Override
        protected Object doGetValue(Object source) {
            return null;
        }

        @Override
        protected void doSetValue(Object source, Object value) {
        }

        @Override
        public INativePropertyListener adaptListener(ISimplePropertyListener listener) {
            return null;
        }
    }
}

