/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.base.addons;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MArea;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.fx.ui.workbench.renderers.base.addons.MinMaxAddonWithPartialRestore;

class MinMaxAddonUtil {
    private static final String ID_EDITOR_AREA = "org.eclipse.ui.editorss";
    private static String MIN_MAXIMIZEABLE_CHILDREN_AREA_TAG = "MinMaximizeableChildrenArea";

    private MinMaxAddonUtil() {
    }

    public static boolean isMinMaxChildrenAreaWithMultipleVisibleChildren(MUIElement element) {
        if (!element.getTags().contains(MIN_MAXIMIZEABLE_CHILDREN_AREA_TAG)) {
            return false;
        }
        if (!(element instanceof MArea)) {
            return false;
        }
        MArea area = (MArea)element;
        if (area.getChildren().isEmpty()) {
            return false;
        }
        return MinMaxAddonUtil.hasMoreThenOneVisibleRenderableChild((MPartSashContainerElement)area.getChildren().get(0));
    }

    private static boolean hasMoreThenOneVisibleRenderableChild(MPartSashContainerElement elementToCheck) {
        if (elementToCheck instanceof MPartSashContainer) {
            int partsToRender = 0;
            for (MPartSashContainerElement part : ((MPartSashContainer)elementToCheck).getChildren()) {
                boolean hasMinimizeableChild = MinMaxAddonUtil.hasMoreThenOneVisibleRenderableChild(part);
                if (hasMinimizeableChild) {
                    return true;
                }
                if (!MinMaxAddonUtil.isVisible((MUIElement)part)) continue;
                ++partsToRender;
            }
            if (partsToRender > 1) {
                return true;
            }
        }
        return false;
    }

    private static boolean isVisible(MUIElement part) {
        boolean visible;
        boolean bl = visible = part.isToBeRendered() && part.isVisible();
        if (part instanceof MElementContainer && visible) {
            visible = false;
            for (Object element : ((MElementContainer)part).getChildren()) {
                MUIElement innerElement = (MUIElement)element;
                visible |= MinMaxAddonUtil.isVisible(innerElement);
            }
        }
        return visible;
    }

    public static void ignoreChildrenOfMinMaxChildrenArea(EModelService modelService, MUIElement element, List<MUIElement> curMax) {
        if (element instanceof MPlaceholder && ((MPlaceholder)element).getRef().getTags().contains(MIN_MAXIMIZEABLE_CHILDREN_AREA_TAG)) {
            LinkedHashSet<MUIElement> toRemove = new LinkedHashSet<MUIElement>();
            for (MUIElement maxElement : curMax) {
                if (modelService.find(maxElement.getElementId(), element) == null) continue;
                toRemove.add(maxElement);
            }
            curMax.removeAll(toRemove);
        }
    }

    public static void addChildrenOfMinMaxChildrenAreaToRestoreList(EModelService modelService, MUIElement element, MWindow win, MPerspective persp, List<MUIElement> elementsToRestore) {
        List areas = modelService.findElements((MUIElement)(persp == null ? win : persp), ID_EDITOR_AREA, MPlaceholder.class, null, 11);
        for (MPlaceholder placeholder : areas) {
            List partStacks;
            if (placeholder == element || win != MinMaxAddonUtil.getWindowFor((MUIElement)placeholder) || !placeholder.getRef().getTags().contains(MIN_MAXIMIZEABLE_CHILDREN_AREA_TAG) || (partStacks = modelService.findElements((MUIElement)placeholder, null, MPartStack.class, null)).contains(element)) continue;
            for (MPartStack partStack : partStacks) {
                elementsToRestore.remove(partStack);
            }
        }
    }

    public static void restoreStacksOfMinMaxChildrenArea(MinMaxAddonWithPartialRestore minMaxAddon, MUIElement element, List<String> maximizeTag) {
        MArea area;
        if (element instanceof MPartStack && (area = MinMaxAddonUtil.getAreaFor((MPartStack)element)) != null && area.getTags().contains(MIN_MAXIMIZEABLE_CHILDREN_AREA_TAG)) {
            List maximizedAreaChildren = minMaxAddon.modelService.findElements((MUIElement)area, null, MPartStack.class, maximizeTag);
            minMaxAddon.executeWithIgnoredTagChanges(() -> {
                for (MPartStack partStack : maximizedAreaChildren) {
                    partStack.getTags().remove("Maximized");
                    minMaxAddon.adjustCTFButtons((MUIElement)partStack);
                }
            });
        }
    }

    public static void maximizeMinMaxChildrenArea(MinMaxAddonWithPartialRestore minMaxAddon, MUIElement element) {
        MArea area;
        if (element instanceof MPartStack && (area = MinMaxAddonUtil.getAreaFor((MPartStack)element)) != null && area.getTags().contains(MIN_MAXIMIZEABLE_CHILDREN_AREA_TAG)) {
            MPlaceholder placeholder = area.getCurSharedRef();
            minMaxAddon.executeWithIgnoredTagChanges(() -> {
                boolean bl = placeholder.getTags().add("Maximized");
            });
            minMaxAddon.adjustCTFButtons((MUIElement)placeholder);
        }
    }

    public static void handleMinimizeOfMinMaxChildrenArea(EModelService modelService, MUIElement element, MWindow win, MPerspective persp, List<MUIElement> elementsToMinimize) {
        List areas = modelService.findElements((MUIElement)(persp == null ? win : persp), ID_EDITOR_AREA, MPlaceholder.class, null, 29);
        boolean foundRelevantArea = false;
        for (MPlaceholder placeholder : areas) {
            if (placeholder == element || win != MinMaxAddonUtil.getWindowFor((MUIElement)placeholder) || modelService.find(element.getElementId(), (MUIElement)placeholder) == null) continue;
            if (placeholder.getRef().getTags().contains(MIN_MAXIMIZEABLE_CHILDREN_AREA_TAG)) {
                foundRelevantArea = true;
            }
            List partStacks = modelService.findElements((MUIElement)placeholder, null, MPartStack.class, null);
            for (MPartStack partStack : partStacks) {
                if (partStack == element) continue;
                elementsToMinimize.add((MUIElement)partStack);
            }
        }
        if (foundRelevantArea) {
            ArrayList<MUIElement> elementsToRemove = new ArrayList<MUIElement>();
            for (MUIElement elementMUI : elementsToMinimize) {
                List findElements = modelService.findElements(elementMUI, element.getElementId(), null, null);
                if (findElements == null || findElements.size() == 0) continue;
                elementsToRemove.add(elementMUI);
            }
            elementsToMinimize.removeAll(elementsToRemove);
        }
    }

    public static void unzoomStackOfMinMaxChildrenArea(MinMaxAddonWithPartialRestore minMaxAddon, MUIElement element) {
        MArea area;
        if (element instanceof MPartStack && (area = MinMaxAddonUtil.getAreaFor((MPartStack)element)) != null && area.getTags().contains(MIN_MAXIMIZEABLE_CHILDREN_AREA_TAG)) {
            MPlaceholder placeholder = area.getCurSharedRef();
            minMaxAddon.executeWithIgnoredTagChanges(() -> {
                boolean bl = placeholder.getTags().remove("Maximized");
            });
            minMaxAddon.adjustCTFButtons((MUIElement)placeholder);
        }
    }

    public static boolean isPartOfMinMaxChildrenArea(MUIElement element) {
        MArea area;
        return element instanceof MPartStack && (area = MinMaxAddonUtil.getAreaFor((MPartStack)element)) != null && area.getTags().contains(MIN_MAXIMIZEABLE_CHILDREN_AREA_TAG);
    }

    public static MArea getAreaFor(MPartStack stack) {
        MElementContainer parent = stack.getParent();
        while (parent != null) {
            if (parent instanceof MArea) {
                return (MArea)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    public static MWindow getWindowFor(MUIElement element) {
        Object parent = element.getParent();
        while (parent != null && !(parent instanceof MWindow)) {
            parent = parent.getTags().contains(MIN_MAXIMIZEABLE_CHILDREN_AREA_TAG) && parent instanceof MArea ? ((MArea)parent).getCurSharedRef() : parent.getParent();
        }
        return (MWindow)parent;
    }
}

