/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.databinding.internal;

import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IDiff;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.IProperty;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.NativePropertyListener;
import org.eclipse.fx.ui.databinding.internal.ControlValueProperty;
import org.eclipse.jdt.annotation.NonNull;

public abstract class ControlReadOnlyPropertyValueProperty<S, T>
extends ControlValueProperty<S, T> {
    protected T doGetValue(S source) {
        ReadOnlyProperty<T> p = this.getProperty(source);
        return (T)p.getValue();
    }

    protected abstract @NonNull ReadOnlyProperty<T> getProperty(S var1);

    public INativePropertyListener<S> adaptListener(ISimplePropertyListener<S, ValueDiff<? extends T>> listener) {
        return new ListenerImpl((IProperty)this, listener);
    }

    class ListenerImpl
    extends NativePropertyListener<S, ValueDiff<? extends T>>
    implements ChangeListener<T> {
        private S owner;

        public ListenerImpl(IProperty property, ISimplePropertyListener<S, ValueDiff<? extends T>> listener) {
            super(property, listener);
        }

        public void changed(ObservableValue<? extends T> observable, T oldValue, T newValue) {
            this.fireChange(this.owner, (IDiff)Diffs.createValueDiff(oldValue, newValue));
        }

        protected void doAddTo(S source) {
            this.owner = source;
            ReadOnlyProperty p = ControlReadOnlyPropertyValueProperty.this.getProperty(source);
            p.addListener((ChangeListener)this);
        }

        protected void doRemoveFrom(S source) {
            this.owner = null;
            ReadOnlyProperty p = ControlReadOnlyPropertyValueProperty.this.getProperty(source);
            p.removeListener((ChangeListener)this);
        }
    }
}

