/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.drift.internal.jni.win32;

import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.fx.drift.internal.DriftFX;
import org.eclipse.fx.drift.internal.DriftLogger;

public enum HRESULT {
    E_OUTOFMEMORY(2147942414L),
    E_INVALIDARG(2147942487L),
    D3DERR_INVALIDCALL(2289436780L),
    D3DERR_OUTOFVIDEOMEMORY(2289435004L);

    private static final DriftLogger LOGGER;
    public long value;

    private HRESULT(long value) {
        this.value = value;
    }

    public static HRESULT fromValue(long value) {
        Optional<HRESULT> code = Stream.of(HRESULT.values()).filter(v -> v.value == value).findFirst();
        if (code.isPresent()) {
            return code.get();
        }
        LOGGER.error(() -> "Error code not yet supported: " + Long.toHexString(value), new Exception());
        return null;
    }

    static {
        LOGGER = DriftFX.createLogger(HRESULT.class);
    }
}

