/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.drift.internal.jni;

import java.nio.ByteBuffer;
import java.util.Stack;
import org.eclipse.fx.drift.internal.DriftFX;
import org.eclipse.fx.drift.internal.DriftLogger;
import org.eclipse.fx.drift.internal.jni.IMemoryStack;
import org.eclipse.fx.drift.internal.jni.Pointer;

public class MemoryStack
implements IMemoryStack {
    private static final DriftLogger LOGGER = DriftFX.createLogger(MemoryStack.class);
    private long address;
    private ByteBuffer buffer;
    private int beginOffset = 0;
    private Stack<Integer> stack = new Stack();
    private static ThreadLocal<MemoryStack> localStack = new ThreadLocal();

    public static MemoryStack get() {
        if (localStack.get() == null) {
            localStack.set(new MemoryStack());
        }
        return localStack.get();
    }

    public static IMemoryStack.IScopedMemeoryStack scoped() {
        return MemoryStack.get().new ScopedMemoryStack();
    }

    public MemoryStack() {
        this.buffer = ByteBuffer.allocateDirect(0x100000);
        this.address = MemoryStack.nGetBufferAddress(this.buffer);
    }

    private static native long nGetBufferAddress(ByteBuffer var0);

    public static long getBufferAddress(ByteBuffer buffer) {
        return MemoryStack.nGetBufferAddress(buffer);
    }

    public long getAddress() {
        return this.address;
    }

    @Override
    public Long allocateLong() {
        Long value = new Long(this.beginOffset);
        value.allocate();
        return value;
    }

    @Override
    public Long allocateLong(long initialValue) {
        Long value = this.allocateLong();
        value.set(initialValue);
        return value;
    }

    public void push() {
        this.stack.push(this.beginOffset);
    }

    public void pop() {
        this.beginOffset = this.stack.pop();
    }

    private static native void nSetLong(long var0, long var2);

    private static native void nOutputLong(long var0);

    public static void output(IMemoryStack stack, Long t) {
        LOGGER.debug(() -> "0x" + java.lang.Long.toHexString(t.get()) + " (" + t.get() + ")");
        MemoryStack.nOutputLong(t.getAddress());
    }

    public static void main(String[] args) {
        DriftFX.require();
        MemoryStack stack = new MemoryStack();
        Long l1 = stack.allocateLong();
        MemoryStack.output(stack, l1);
        MemoryStack.nSetLong(stack.getAddress(), java.lang.Long.MAX_VALUE);
        MemoryStack.output(stack, l1);
        Long l2 = stack.allocateLong();
        l2.set(258L);
        stack.push();
        Long l3 = stack.allocateLong();
        l3.set(3L);
        Long l4 = stack.allocateLong();
        l4.set(4L);
        MemoryStack.output(stack, l4);
        stack.pop();
        l3 = stack.allocateLong();
        MemoryStack.output(stack, l3);
    }

    class ScopedMemoryStack
    implements IMemoryStack.IScopedMemeoryStack {
        ScopedMemoryStack() {
            MemoryStack.this.push();
        }

        @Override
        public void close() {
            MemoryStack.this.pop();
        }

        @Override
        public Long allocateLong() {
            return MemoryStack.this.allocateLong();
        }

        @Override
        public Long allocateLong(long initialValue) {
            return MemoryStack.this.allocateLong(initialValue);
        }
    }

    public class Long
    extends StackData {
        public Long(int offset) {
            super(offset, 64);
        }

        public long get() {
            MemoryStack.this.buffer.position(this.offset);
            byte[] data = new byte[this.size / 8];
            MemoryStack.this.buffer.get(data);
            return this.bytesToLong(data, 0);
        }

        public void set(long value) {
            MemoryStack.nSetLong(MemoryStack.this.address + (long)this.offset, value);
        }

        public long bytesToLong(byte[] bytes, int offset) {
            long result = 0L;
            for (int i = 7; i >= 0 + offset; --i) {
                result <<= 8;
                result |= (long)(bytes[i] & 0xFF);
            }
            return result;
        }
    }

    public class StackData
    implements Pointer {
        public final int offset;
        public final int size;

        public StackData(int offset, int size) {
            this.offset = offset;
            this.size = size;
        }

        public void allocate() {
            MemoryStack.this.beginOffset = MemoryStack.this.beginOffset + this.size;
        }

        @Override
        public long getAddress() {
            return MemoryStack.this.address + (long)this.offset;
        }
    }
}

