/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efbt.openregspecs.model.open_reg_specs;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Comparitor implements Enumerator
{
    LESS_THAN(0, "less_than", "less_than"),
    EQUALS(0, "equals", "equals"),
    GREATER_THAN(0, "greater_than", "greater_than");

    public static final int LESS_THAN_VALUE = 0;
    public static final int EQUALS_VALUE = 0;
    public static final int GREATER_THAN_VALUE = 0;
    private static final Comparitor[] VALUES_ARRAY;
    public static final List<Comparitor> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Comparitor[]{LESS_THAN, EQUALS, GREATER_THAN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Comparitor get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Comparitor result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Comparitor getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Comparitor result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Comparitor get(int value) {
        switch (value) {
            case 0: {
                return LESS_THAN;
            }
        }
        return null;
    }

    private Comparitor(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

