/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.markers;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFactory;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.pde.api.tools.ui.internal.markers.MarkerMessages;
import org.eclipse.pde.api.tools.ui.internal.markers.SinceTagResolution;
import org.eclipse.pde.api.tools.ui.internal.markers.VersionNumberingResolution;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Version;

public class SinceTagAfterVersionUpdateResolution
extends SinceTagResolution {
    IMarker markerVersion = null;
    private int dialogResult = -1;

    public SinceTagAfterVersionUpdateResolution(IMarker markerVer, IMarker marker) {
        super(marker);
        this.markerVersion = markerVer;
    }

    @Override
    public String getLabel() {
        return NLS.bind((String)MarkerMessages.SinceTagResolution_add_since_tag_after_version_update, (Object)this.markerVersion.getAttribute("version", null));
    }

    @Override
    public void run(IMarker marker) {
        if (this.markerVersion != null) {
            if (1 == ApiProblemFactory.getProblemKind((int)this.markerVersion.getAttribute("problemid", 0))) {
                int[] result = new int[1];
                SinceTagAfterVersionUpdateResolution.getDisplay().syncExec(() -> {
                    String title = MarkerMessages.SinceTagAfterVersionUpdateResolution_confirm;
                    MessageDialog dialog = new MessageDialog(this.getActiveShell(), title, null, MarkerMessages.SinceTagAfterVersionUpdateResolution_question, 3, 1, new String[]{MarkerMessages.SinceTagAfterVersionUpdateResolution_update, MarkerMessages.SinceTagAfterVersionUpdateResolution_dont_update, IDialogConstants.CANCEL_LABEL});
                    nArray[0] = dialog.open();
                    this.dialogResult = result[0];
                });
            }
            if (this.dialogResult == 2) {
                return;
            }
            if (this.dialogResult == 1) {
                super.run(marker);
                return;
            }
            new VersionNumberingResolution(this.markerVersion).run(this.markerVersion);
            String componentVersionString = this.markerVersion.getAttribute("version", null);
            StringBuilder buffer = new StringBuilder();
            Version componentVersion = new Version(componentVersionString);
            buffer.append(componentVersion.getMajor()).append('.').append(componentVersion.getMinor());
            try {
                this.markerVersion.setAttribute("version", (Object)buffer.toString());
            }
            catch (CoreException e) {
                ApiUIPlugin.log(e);
            }
            this.newVersionValue = this.markerVersion.getAttribute("version", null);
        }
        try {
            marker.setAttribute("version", (Object)this.newVersionValue);
        }
        catch (CoreException e) {
            ApiUIPlugin.log(e);
        }
        super.run(marker);
    }

    @Override
    public String getDescription() {
        return NLS.bind((String)MarkerMessages.SinceTagResolution_add_since_tag_after_version_update, (Object)this.markerVersion.getAttribute("version", null));
    }

    @Override
    public IMarker[] findOtherMarkers(IMarker[] markers) {
        return new IMarker[0];
    }

    public Shell getActiveShell() {
        return PlatformUI.getWorkbench().getModalDialogShellProvider().getShell();
    }

    private static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }
}

