/*
 * Copyright (c) 2015, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: OnMessageServerEndpoint.java 74509 2015-05-25 13:33:41Z jsupol $
 */

package com.sun.ts.tests.websocket.negdep.onmessage.srv.pongduplicate;

import java.io.IOException;

import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.PongMessage;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;

import com.sun.ts.tests.websocket.common.util.IOUtil;

@ServerEndpoint("/invalid")
public class OnMessageServerEndpoint {

	@OnMessage
	public String echo(PongMessage pong) throws IOException {
		return IOUtil.byteBufferToString(pong.getApplicationData());
	}
	
	@OnMessage
	public String echo(PongMessage pong, Session session) throws IOException {
		return IOUtil.byteBufferToString(pong.getApplicationData());
	}

	@OnError
	public void onError(Session session, Throwable thr) throws IOException {
		thr.printStackTrace(); // Write to error log, too
		String message = IOUtil.printStackTrace(thr);
		session.getBasicRemote().sendText(message);
	}
}
