/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: WSTestServer.java 70499 2013-03-08 03:39:52Z djiao $
 */
package com.sun.ts.tests.websocket.ee.javax.websocket.websocketcontainer;

import java.io.IOException;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;

@ServerEndpoint(value = "/TCKTestServer")
public class WSTestServer {

	@OnOpen
	public void init(Session session) throws IOException {
		System.out.println("===============================");
		session.getBasicRemote().sendText("TCKTestServer opened");
	}

	@OnMessage
	public void respond(String message, Session session) throws IOException {
		System.out.println("TCKTestServer got  message: " + message
				+ " from session " + session);
		session.getBasicRemote().sendText("TCKTestServer received: " + message);
		session.getBasicRemote().sendText("TCKTestServer responds");
	}

	@OnError
	public void onError(Session session, Throwable t) throws IOException {
		session.getBasicRemote().sendText("TCKTestServer onError");
		t.printStackTrace();
	}
}