/*
 * Copyright (c) 2014, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: WSCBinaryEchoServerEndpoint.java 73928 2014-08-01 09:35:37Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.session11.client;

import java.io.IOException;
import java.nio.ByteBuffer;

import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;

import com.sun.ts.tests.websocket.common.util.IOUtil;

@ServerEndpoint(value = "/binecho")
public class WSCBinaryEchoServerEndpoint {
	public static final String SAYS = "Binary Server says:";

	@OnMessage
	public ByteBuffer onMessage(ByteBuffer text) {
		return ByteBuffer.wrap((SAYS + IOUtil.byteBufferToString(text))
				.getBytes());
	}

	@OnError
	public void onError(Session session, Throwable t) throws IOException {
		System.out.println("@OnError in " + getClass().getName());
		t.printStackTrace(); // Write to error log, too
		String message = "Exception: " + IOUtil.printStackTrace(t);
		session.getBasicRemote().sendBinary(ByteBuffer.wrap(message.getBytes()));
	}
}
