/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: WSMaxLengthClientEndpoint.java 72761 2013-08-30 17:06:49Z supol $s
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.clientendpointonmessage;

import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;

import com.sun.ts.tests.websocket.common.client.AnnotatedStringClientEndpoint;
import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;

@ClientEndpoint
public class WSMaxLengthClientEndpoint extends AnnotatedStringClientEndpoint {
	public static final String MSG = "maxMessageSize casts an exception as expected:";

	@OnMessage(maxMessageSize = 5L)
	public String echo(String echo) {
		super.onMessage(echo);
		return echo;
	}

	@OnError
	@Override
	public void onError(Session session, Throwable t) {
		String message = WebSocketCommonClient.getCauseMessage(t);
		WebSocketCommonClient.logMsg(MSG, message);
	}

	@OnClose
	@Override
	public void onClose(Session session, CloseReason closeReason) {
		super.onClose(session, closeReason);
	}

	@OnOpen
	@Override
	public void onOpen(Session session, EndpointConfig config) {
		super.onOpen(session, config);
	}
}
