/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: WSCSubprotocolServer.java 72743 2013-08-28 17:30:13Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.clientendpoint;

import java.io.IOException;

import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;

import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.common.util.StringUtil;

@ServerEndpoint(value = "/subprotocol", subprotocols = {
		StringUtil.WEBSOCKET_SUBPROTOCOLS_0,
		StringUtil.WEBSOCKET_SUBPROTOCOLS_1 }, configurator = GetNegotiatedSubprotocolConfigurator.class)
public class WSCSubprotocolServer {

	@OnMessage
	public String echo(String msg) {
		OPS op = OPS.valueOf(msg);
		switch (op) {
		case ECHO_MSG:
			break;
		case NEGOTIATED:
			msg = "{"
					+ GetNegotiatedSubprotocolConfigurator.getResulted().trim()
					+ "}";
			break;
		default:
			throw new IllegalArgumentException("Operation" + msg
					+ "has not been implemented");
		}
		return msg;
	}

	@OnError
	public void onError(Session session, Throwable t) throws IOException {
		System.out.println("@OnError in" + getClass().getName());
		t.printStackTrace(); // Write to error log, too
		String message = IOUtil.printStackTrace(t);
		session.getBasicRemote().sendText(message);
	}
}
