/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: URLClient.java 62542 2011-04-15 16:55:08Z adf $
 */

package com.sun.ts.tests.saaj.api.javax_xml_soap.SOAPConstants;

import com.sun.ts.lib.util.*;
import com.sun.ts.lib.porting.*;
import com.sun.ts.lib.harness.*;

import java.io.*;
import java.net.*;
import java.util.*;
import java.rmi.*;

import com.sun.javatest.Status;

public class URLClient extends EETest
{
    private static final String PROTOCOL = "http";
    private static final String HOSTNAME = "localhost";
    private static final int PORTNUM  = 8000;
    private static final String SOAPCONSTANTS_TESTSERVLET  = 
		"/SOAPConstants_web/SOAPConstantsTestServlet";

    private static final String WEBSERVERHOSTPROP = "webServerHost";
    private static final String WEBSERVERPORTPROP = "webServerPort";

    private TSURL tsurl = new TSURL();
    private URL url = null;
    private URLConnection     urlConn = null;
    private Properties props = null;
    private String hostname = HOSTNAME;
    private int portnum = PORTNUM;

    public static void main(String[] args) 
    {
	URLClient theTests = new URLClient();
	Status s = theTests.run(args, System.out, System.err);
	s.exit();
    }


/*  Test setup */

  /*
   *   @class.setup_props: webServerHost;
   *                       webServerPort;
   */

    public void setup(String[] args, Properties p) throws Fault
    {
        props = p;
	boolean pass = true;

        try {
	    hostname = p.getProperty(WEBSERVERHOSTPROP);
	    if (hostname == null)
		      pass = false;
	    else if (hostname.equals(""))
		      pass = false;
	    try { 
		portnum = Integer.parseInt(p.getProperty(WEBSERVERPORTPROP));
	    } catch (Exception e) { 
		      pass = false; 
	    }
         } catch (Exception e) {
	    throw new Fault("setup failed:", e);
         }
	 if (!pass) {
	    TestUtil.logErr("Please specify host & port of web server " +
			    "in config properties: " + WEBSERVERHOSTPROP +
			    ", " + WEBSERVERPORTPROP);
	    throw new Fault("setup failed:");
	 }
        logMsg("setup ok");
    }

    public void cleanup()  throws Fault {
        logMsg("cleanup ok");
    }

    /*
     *   @testName:  SOAPConstantsTest
     *
     *   @assertion_ids: SAAJ:JAVADOC:0;
     *
     *   @test_Strategy: Verify the SOAP1.1 and SOAP1.2 protocol constants
     *
     *   Description: Verify the SOAP1.1 and SOAP1.2 protocol constants
     *
     */
    public void SOAPConstantsTest() throws Fault {
	boolean pass = true;
        try {

	    TestUtil.logMsg(
		"SOAPConstantsTest: verify SOAP1.1 and SOAP1.2 protocol constants");
	    TestUtil.logMsg("Creating url to test servlet.....");
    	    url = tsurl.getURL(PROTOCOL, hostname, portnum, 
			SOAPCONSTANTS_TESTSERVLET);
	    TestUtil.logMsg(url.toString());
	    TestUtil.logMsg("Sending post request to test servlet.....");
	    props.setProperty("TESTNAME", "SOAPConstantsTest");
	    urlConn = TestUtil.sendPostData(props, url);
	    TestUtil.logMsg("Getting response from test servlet.....");
	    Properties resProps = TestUtil.getResponseProperties(urlConn);
	    if(!resProps.getProperty("TESTRESULT").equals("pass"))
	        pass = false;
        } catch (Exception e) {
	    TestUtil.logErr("Caught exception: " + e.getMessage());
            e.printStackTrace();
	    throw new Fault("SOAPConstantsTest failed", e);
        }

	if (!pass)
	    throw new Fault("SOAPConstantsTest failed");
    }
}
