/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $URL: https://adc4110351.us.oracle.com/svn/spider/branches/cts/8.0/src/com/sun/ts/tests/jstl/common/wrappers/FormatRequestWrapper.java $ $LastChangedDate: 2011-04-15 11:32:31 -0700 (Fri, 15 Apr 2011) $
 */

package com.sun.ts.tests.jstl.common.wrappers;

import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletRequest;
import java.io.UnsupportedEncodingException;


public class FormatRequestWrapper extends HttpServletRequestWrapper{

    /** Creates new FormatRequestWrapper */
    public FormatRequestWrapper(HttpServletRequest request) {
        super(request);
    }

/* 
 * public methods
 * ========================================================================
 */
    
    /**
     * This wrapper method will add an attribute to the passed request
     * when this method is called.
     */
    public void setCharacterEncoding(String enc) 
      throws UnsupportedEncodingException {
        super.setAttribute("charenc", enc.toLowerCase());
        super.setCharacterEncoding(enc);
    }

    
}
