/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: ClassicBodyTag.java 62554 2011-04-15 18:08:28Z dougd $
 */
 
package com.sun.ts.tests.jsp.spec.core_syntax.actions.body;

import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.DynamicAttributes;
import javax.servlet.jsp.JspException;
import java.io.IOException;

public class ClassicBodyTag extends BodyTagSupport implements DynamicAttributes {

    public void setDynamicAttribute(String s, String s1, Object o)
    throws JspException {
        // no op
    }

    public int doEndTag() throws JspException {
        BodyContent content = getBodyContent();
        if (content != null) {
            try {
                String body = content.getString().trim();
                if ("testpassed".equals(body)) {
                    content.getEnclosingWriter().println("Test PASSED");
                } else {
                    content.getEnclosingWriter().println("Test FAILED." +
                        "  Expected body to be 'testpassed'.  Received: " +
                        body);
                }
            } catch (IOException ioe) {
                throw new JspException("Unexpected IOException!", ioe);
            }
        }
        return EVAL_PAGE;
    }
}
