/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: ClassicParent.java 62554 2011-04-15 18:08:28Z dougd $
 */

/*
 * @(#)ClassicParent.java 1.1 10/31/02
 */
 
package com.sun.ts.tests.jsp.api.javax_servlet.jsp.tagext.simpletagsupport;

import com.sun.ts.tests.jsp.common.util.JspTestUtil;

import javax.servlet.jsp.tagext.TagSupport;

/**
 * A simple tag to help verify nested tag behavior.
 */
public class ClassicParent extends TagSupport {

    /**
     * The nested level.
     */
    private String _level = null;

    /**
     * Default constructor.
     */
    public ClassicParent() {
        super();
    }

    /**
     * Sets the nesting level.
     * @param level - the nesting level
     */
    public void setLevel(String level) {
        _level = level;
    }

    /**
     * Gets the nesting level of this tag.
     * @return the defined nesting level
     */
    public String getLevel() {
        return _level;
    }

    /**
     * Returns EVAL_BODY_INCLUDE.
     * @return Tag.EVAL_BODY_INCLUDE
     */
    public int doStartTag() {
        JspTestUtil.debug("[ClassicParent] in doStartTag()");
        return EVAL_BODY_INCLUDE;
    }
}
