/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: CheckInstanceSimpleTag.java 62554 2011-04-15 18:08:28Z dougd $
 */
 
package com.sun.ts.tests.jsp.api.javax_servlet.jsp.tagext.simpletagsupport;

import javax.servlet.jsp.tagext.SimpleTagSupport;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.JspWriter;
import java.io.IOException;
import java.util.List;
import java.util.ArrayList;
import com.sun.ts.tests.jsp.common.util.JspTestUtil;

public class CheckInstanceSimpleTag extends SimpleTagSupport {
    public CheckInstanceSimpleTag() {
        super();
    }

    public void doTag() throws JspException, IOException {
        JspTestUtil.debug("[CheckInstanceSimpleTag] in doTag()");
        JspContext ctx = this.getJspContext();
        JspWriter out = ctx.getOut();

        Object obj = ctx.getAttribute("handlers", PageContext.REQUEST_SCOPE);
        List handlers = null;
        if(obj == null) {
            handlers = new ArrayList();
            ctx.setAttribute("handlers", handlers, PageContext.REQUEST_SCOPE);        
        } else {
            handlers = (List) obj;
        }
        int numHandlers = handlers.size();
        out.println("Comparing with prior " + numHandlers + " instances of CheckInstanceSimpleTag");
        for(int i = 0; i < numHandlers; i++) {
            Object o = handlers.get(i);
            if(this == o) {
                throw new JspException("Test FAILED. The same instance of CheckInstanceSimpleTag is used in this invocation: " + this);
            }
        }
        handlers.add(this);
    }
}
