/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.jsp.api.javax_el.methodinfo;

import com.sun.ts.tests.jsp.common.util.JspTestUtil;
import com.sun.ts.tests.common.el.api.expression.ExpressionTest;
import javax.el.MethodExpression;
import javax.el.MethodInfo;
import javax.el.ELContext;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import java.io.*;

public class MethodInfoTag extends SimpleTagSupport {

    private MethodExpression mexp;

    public void setMethExpr(MethodExpression mexp) {
        this.mexp = mexp;
    }

    public void doTag() throws JspException, IOException {

        JspWriter out = getJspContext().getOut();
        StringBuffer buf = new StringBuffer("");
        ELContext elContext = getJspContext().getELContext();

        try {
	    MethodInfo minfo = mexp.getMethodInfo(elContext);
            Class [] paramTypes = {Object.class};
            boolean pass = ExpressionTest.testMethodInfo(
                    minfo, "add", boolean.class, 1, paramTypes, buf);

            if (!pass) {
                out.println("Test FAILED: return from testMethodExpression\n");
                out.println("Buffer contents:\n" + buf.toString());
                return;
            }

            mexp.invoke(elContext, new Object[] {"latest member"});
        } catch (Throwable t) {
            out.println("Test FAILED: Exception in tag handler\n");
            out.println("Buffer contents:\n" + buf.toString());
            JspTestUtil.handleThrowable(t, out, "MethodInfoTag");
        }
    }
}
