/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.lib;

import com.sun.javatest.Status;
import com.sun.javatest.Test;
import com.sun.javatest.lib.TestCases;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class MultiTest
implements Test {
    private TestCases testCases;
    private boolean testNotApplicable;
    protected PrintWriter ref;
    protected PrintWriter log;

    public Status run(String[] args, PrintWriter log, PrintWriter ref) {
        this.log = log;
        this.ref = ref;
        this.testCases = new TestCases(this, log);
        Status initStatus = this.init(args);
        if (this.testNotApplicable || initStatus != null && initStatus.getType() != 0) {
            return initStatus;
        }
        return this.testCases.invokeTestCases();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Status run(String[] argv, PrintStream log, PrintStream ref) {
        PrintWriter pwLog = new PrintWriter(new OutputStreamWriter(log));
        PrintWriter pwRef = new PrintWriter(new OutputStreamWriter(ref));
        try {
            Status status = this.run(argv, pwLog, pwRef);
            return status;
        }
        finally {
            pwLog.flush();
            pwRef.flush();
        }
    }

    protected Status init(String[] args) {
        try {
            this.decodeAllArgs(args);
            this.init();
            return null;
        }
        catch (SetupException e) {
            this.testNotApplicable = true;
            return e.isPassed() ? Status.passed(e.getMessage()) : Status.failed(e.getMessage());
        }
    }

    protected void init() throws SetupException {
    }

    protected final void decodeAllArgs(String[] args) throws SetupException {
        int elementsConsumed;
        for (int i = 0; i < args.length; i += elementsConsumed) {
            elementsConsumed = this.decodeArg(args, i);
            if (elementsConsumed != 0) continue;
            throw new SetupException("Could not recognize argument: " + args[i]);
        }
    }

    protected int decodeArg(String[] args, int index) throws SetupException {
        try {
            if (args[index].equals("-select") && index + 1 < args.length) {
                this.testCases.select(args[index + 1]);
                return 2;
            }
            if (args[index].equals("-exclude") && index + 1 < args.length) {
                this.testCases.exclude(args[index + 1]);
                return 2;
            }
            if (args[index].equals("-TestCaseID")) {
                int i;
                if (index + 1 < args.length && args[index + 1].equals("ALL")) {
                    return 2;
                }
                for (i = index + 1; i < args.length && !args[i].startsWith("-"); ++i) {
                    this.testCases.select(args[i]);
                }
                return i - index;
            }
            if (args[index].equals("-autoFlush")) {
                this.ref = new PrintWriter((Writer)this.ref, true);
                this.log = new PrintWriter((Writer)this.ref, true);
                return 1;
            }
            return 0;
        }
        catch (TestCases.Fault e) {
            throw new SetupException(e.getMessage());
        }
    }

    protected Status invokeTestCase(Method m) throws IllegalAccessException, InvocationTargetException {
        Object[] testArgs = new Object[]{};
        return (Status)m.invoke((Object)this, testArgs);
    }

    public static class SetupException
    extends Exception {
        private boolean passed = false;

        public SetupException(String s) {
            super(s);
        }

        public static SetupException notApplicable(String msg) {
            SetupException e = new SetupException("Test not applicable: " + msg);
            e.passed = true;
            return e;
        }

        public boolean isPassed() {
            return this.passed;
        }
    }
}

