/*
 * Copyright (c) 2009, 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.jpa.se.cache.inherit;

import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;

/*
 * HardwareProduct
 */

@Entity
@DiscriminatorValue("HW2")
public class HardwareProduct2 extends Product2
        implements java.io.Serializable {
	private static final long serialVersionUID = 22L;
	
	// Instance variables
    private int modelNumber;

    public HardwareProduct2() {
        super();
    }


    // ===========================================================
    // getters and setters for the state fields

    @Column(name = "MODEL", nullable = true)
    public int getModelNumber() {
        return modelNumber;
    }

    public void setModelNumber(int modelNumber) {
        this.modelNumber = modelNumber;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName() + "[");
        result.append("id: " + getId());
        result.append(", modelNumber: " + getModelNumber());
        result.append(", quantity: " + getQuantity());
        result.append("]");
        return result.toString();
    }
}
