/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
* ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
*/
package com.sun.ts.tests.jpa.core.annotations.convert;

import javax.persistence.AttributeConverter;
import javax.persistence.Converter;

@Converter(autoApply = false)
public class DotConverter implements AttributeConverter<String, String> {

    public String convertToDatabaseColumn(String attribute) {
        System.out.println("*** Entering DotConverter:convertToDatabaseColumn["+attribute+"] ***");
        String s = attribute.replace(".","#");
        System.out.println("*** Leaving DotConverter:convertToDatabaseColumn["+s+"] ***");
        return s;
    }

    public String convertToEntityAttribute(String dbData) {
        System.out.println("*** Entering DotConverter:convertToEntityAttribute["+dbData+"] ***");
        String s = dbData.replace("#","_");
        System.out.println("*** Leaving DotConverter:convertToEntityAttribute["+s+"] ***");
        return s;

    }

}

