/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.report;

import com.sun.javatest.InterviewParameters;
import com.sun.javatest.TestFilter;
import com.sun.javatest.report.Report;
import com.sun.javatest.report.XMLReport;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import org.xml.sax.SAXException;

public abstract class CustomReport {
    private ReportEnviroment env;

    public boolean needsXmlReport() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final InputStream getXmlReport() throws IOException, SAXException {
        if (this.needsXmlReport()) {
            File xmlSrc = null;
            if (this.env.xmlReportFile != null) {
                xmlSrc = this.env.xmlReportFile;
            } else if (this.env.tmpXmlReportFile != null) {
                xmlSrc = this.env.tmpXmlReportFile;
            } else {
                this.env.tmpXmlReportFile = File.createTempFile("jtrep", "tmp");
                FileOutputStream fos = new FileOutputStream(this.env.tmpXmlReportFile);
                try {
                    BufferedWriter fw = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));
                    XMLReport xr = new XMLReport();
                    xr.write(fw, this.env);
                    ((Writer)fw).close();
                }
                finally {
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                xmlSrc = this.env.tmpXmlReportFile;
            }
            return new FileInputStream(xmlSrc);
        }
        return null;
    }

    public abstract File createReport(File var1) throws ReportException;

    public abstract File createReport(String var1, File var2, InterviewParameters var3, TestFilter var4) throws ReportException;

    public abstract String getReportId();

    public abstract String getName();

    public abstract String getDescription();

    public ReportEnviroment getReportEnviroment() {
        return this.env;
    }

    public ReportConfigPanel[] getOptionPanes() {
        return null;
    }

    public abstract String validateOptions();

    public void dispose() {
        this.env = null;
    }

    public void setEnviroment(ReportEnviroment envir) {
        this.env = envir;
    }

    public static class ReportEnviroment {
        File xmlReportFile = null;
        File tmpXmlReportFile = null;
        private File[] mif = new File[0];
        private InterviewParameters ip;
        private TestFilter filter;
        private File[] initFiles;
        private HashMap exchangeData;
        private boolean backUpEnabled;
        private int backups;

        public InterviewParameters getIp() {
            return this.ip;
        }

        public TestFilter getFilter() {
            return this.filter;
        }

        public File[] getInitFiles() {
            return this.initFiles;
        }

        public boolean isBackUpEnabled() {
            return this.backUpEnabled;
        }

        public int getBackups() {
            return this.backups;
        }

        public Map getExchangeData() {
            if (this.exchangeData == null) {
                this.exchangeData = new HashMap();
            }
            return this.exchangeData;
        }

        public ReportEnviroment(InterviewParameters ipa, TestFilter f) {
            this.ip = ipa;
            this.filter = f;
            this.initFiles = new File[0];
            this.backUpEnabled = false;
            this.backups = 0;
        }

        public ReportEnviroment(File xmlReportFile, File[] in) {
            this.xmlReportFile = xmlReportFile;
            this.mif = in;
        }

        ReportEnviroment(Report.Settings sett) {
            this.ip = sett.ip;
            this.filter = sett.filter;
            this.initFiles = sett.getInitialFiles();
            this.backUpEnabled = sett.isBackupsEnabled();
            this.backups = sett.backups;
        }

        void cleanup() {
            if (this.tmpXmlReportFile != null) {
                this.tmpXmlReportFile.delete();
            }
            if (this.exchangeData != null) {
                this.exchangeData.clear();
            }
        }

        public void setXMLReportFile(File f) {
            this.xmlReportFile = f;
        }

        public void setMergingFiles(File[] files) {
            this.mif = files;
        }

        public File[] getMergingFiles() {
            return this.mif;
        }
    }

    public static abstract class ReportConfigPanel
    extends JPanel {
        public ReportConfigPanel() {
            this.setFocusable(false);
        }

        public abstract String getPanelName();
    }

    public class ReportException
    extends IOException {
        public ReportException(String message) {
            super(message);
        }
    }
}

