/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * @(#)SigTestRecorder.java	1.1 03/03/05
 */
package com.sun.ts.tests.signaturetest;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>This implementation of {@link Recorder} will record signatures
 * using the <code>ApiCheck</code> framework.</p>
 */
public class ApiCheckRecorder extends Recorder {


    // ------------------------------------------------------------ Constructors


    public ApiCheckRecorder(String[] args) {

        super(args);
        System.setProperty("pkg.list.file.path", packageListFile);
        System.setProperty("map.file.path", signatureMapFile);
        System.setProperty("signature.repository.dir", signatureRepositoryDir);

    } // END ApiCheckRecorder


    // ------------------------------------------------------- Protected Methods


    protected String[] createCommandLine(String version,
                                         String classpath,
                                         String outputFileName,
                                         String packageName)  {

        List command = new ArrayList();

        command.add("-constvalues");
        command.add("-xpriv");

        command.add("-in");
        command.add(classpath);

        return ((String[]) command.toArray(new String[command.size()]));

    } // END getCommandLine


    protected void writePackageListFile(String basePackageName,
                                        String signatureFile,
                                        String packageListFile)
        throws Exception {

        // no-op as this is done internally by our version of ApiCheck

    } // END writePackageListFile


    protected void doRecord(String[] commandLine) throws Exception {

        Class batchSetup = Class.forName("javasoft.sqe.apiCheck.BatchSetup");
        Method mainMethod =
            batchSetup.getDeclaredMethod("main",
                                         new Class[] { String[].class });
        mainMethod.invoke(null, new Object[] { commandLine });        

    } // END doRecord


}  // END SigTestRecorder
