/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: Client.java 62536 2011-04-15 16:35:14Z af70133 $
 */

/* Copyright (c) 2003 Oracle Corporation.  All rights reserved.  */
package com.sun.ts.tests.jaxrpc.wsi.w2j.document.literal.R2020;

import java.util.Properties;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jaxrpc.sharedclients.ClientFactory;

/**
 * Tests R2020 in the WSI Basic Profile 1.0:
 * The wsdl:documentation element MAY occur as a child of the wsdl:import element in
 * a DESCRIPTION.
 */
public class Client extends ServiceEETest {
    /**
     * The string to be echoed.
     */
    private static final String STRING = "R2020";
    
    /**
     * The client.
     */
    private W2JDLR2020Client client;
    /**
     * Test entry point.
     * 
     * @param args the command-line arguments.
     */
    public static void main(String[] args) {
        Client client = new Client();
        Status status = client.run(args, System.out, System.err);
        status.exit();
    }
    
    /**
     * @class.testArgs:     -ap jaxrpc-url-props.dat
     * @class.setup_props: webServerHost;
     *                     webServerPort;
     *                     platform.mode;
     *
     * @param args
     * @param properties
     *
     * @throws Fault
     */
    public void setup(String[] args, Properties properties) throws Fault {
        client = (W2JDLR2020Client)ClientFactory.getClient(W2JDLR2020Client.class, properties);
        logMsg("setup ok");
    }

    public void cleanup() {
        logMsg("cleanup");
    }

    /**
     * @testName: testDocumentLiteralDocumentationElement
     *
     * @assertion_ids: JAXRPC:WSI:R2020
     *
     * @test_Strategy: The supplied WSDL, containg a wsdl:documentation element as a child
     * of the wsdl:import element, has been used by the WSDL-to-Java tool to generate
     * an end point.  If the tool works correctly, the end-point has been built and deployed
     * so it should simply be reachable.
     *
     * @throws Fault
     */
    public void testDocumentLiteralDocumentationElement() throws Fault {
        String result;
        try {
            result = client.echoString(STRING);
        } catch (Exception e) {
            throw new Fault("Unable to invoke echoString operation (BP-R2020)", e);
        }
        if (!STRING.equals(result)) {
            throw new Fault("echoString operation returns '" + result + "' in stead of '" + STRING + "' (BP-R2020)");
        }
    }
}
