/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
/*************************************************************************
   Licensed Materials - Property of IBM
   WSEE1.0 (C) Copyright International Business Machines Corp. 2002
   All Rights Reserved.
   US Government Users Restricted Rights - Use, duplication or
   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
**************************************************************************/
/*************************************************************************
   IBM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
   ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
   PURPOSE. IN NO EVENT SHALL IBM BE LIABLE FOR ANY SPECIAL, INDIRECT OR
   CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
   USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
   OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
   OR PERFORMANCE OF THIS SOFTWARE.
**************************************************************************/

/*
 * $Id: HelloImpl.java 62536 2011-04-15 16:35:14Z af70133 $
 */

package com.sun.ts.tests.jaxrpc.sharedwebservices.helloservice;

import com.sun.ts.lib.util.*;
import com.sun.ts.lib.porting.*;

import com.sun.ts.tests.jaxrpc.common.*;

import java.rmi.Remote;
import java.rmi.RemoteException;

import javax.xml.rpc.server.ServiceLifecycle;
import javax.xml.rpc.server.ServletEndpointContext;

import java.math.BigInteger;
import java.math.BigDecimal;

import javax.xml.namespace.QName;

// Service Implementation Class - as outlined in JAX-RPC Specification

public class HelloImpl implements Hello, ServiceLifecycle {

    private boolean initCalled = false;
    private boolean destroyCalled = false;
    private Object context = null;
    private ServletEndpointContext servletEndpointContext = null;

    public void init(Object context) {
	System.out.println("init called ...");
	initCalled = true;
	this.context = context;
	if (context instanceof ServletEndpointContext)
	    servletEndpointContext = (ServletEndpointContext)context;
    }

    public void destroy() {
	System.out.println("destroy called ...");
	destroyCalled = true;
    }

    public String hello(String s) throws RemoteException {
        return "Hello, " + s + "!";
    }

    public boolean wasInitCalled() throws RemoteException {
	return initCalled;
    }

    public boolean wasDestroyCalled() throws RemoteException {
	//Untestable so always return true;
	return true;
    }

    public String invokeTest1(Boolean p1, Byte p2, Short p3, Integer p4,
        Long p5, Float p6, Double p7) throws RemoteException {

	boolean pass = true;

	if(!p1.equals(JAXRPC_Data.Boolean_data[0])) {
	    TestUtil.logErr("Boolean failed, expected " +
		JAXRPC_Data.Boolean_data[0] + ", received " + p1);
	    pass = false;
	}
	if(!p2.equals(JAXRPC_Data.Byte_data[0])) {
	    TestUtil.logErr("Byte failed, expected " +
		JAXRPC_Data.Byte_data[0] + ", received " + p2);
	    pass = false;
	}
	if(!p3.equals(JAXRPC_Data.Short_data[0])) {
	    TestUtil.logErr("Short failed, expected " +
		JAXRPC_Data.Short_data[0] + ", received " + p3);
	    pass = false;
	}
	if(!p4.equals(JAXRPC_Data.Integer_data[0])) {
	    TestUtil.logErr("Integer failed, expected " +
		JAXRPC_Data.Integer_data[0] + ", received " + p4);
	    pass = false;
	}
	if(!p5.equals(JAXRPC_Data.Long_data[0])) {
	    TestUtil.logErr("Long failed, expected " +
		JAXRPC_Data.Long_data[0] + ", received " + p5);
	    pass = false;
	}
	if(!p6.equals(JAXRPC_Data.Float_data[0])) {
	    TestUtil.logErr("Float failed, expected " +
		JAXRPC_Data.Float_data[0] + ", received " + p6);
	    pass = false;
	}
	if(!p7.equals(JAXRPC_Data.Double_data[0])) {
	    TestUtil.logErr("Double failed, expected " +
		JAXRPC_Data.Double_data[0] + ", received " + p7);
	    pass = false;
	}
	if(pass)
	    return "passed";
	else
	    return "failed";
    }

    public String invokeTest2(BigInteger p1, BigDecimal p2, QName p3, 
		String p4) throws RemoteException {

	boolean pass = true;

	if(!p1.equals(JAXRPC_Data.BigInteger_data[0])) {
	    TestUtil.logErr("BigInteger failed, expected " +
		JAXRPC_Data.BigInteger_data[0] + ", received " + p1);
	    pass = false;
	}
	if(!p2.equals(JAXRPC_Data.BigDecimal_data[0])) {
	    TestUtil.logErr("BigDecimal failed, expected " +
		JAXRPC_Data.BigDecimal_data[0] + ", received " + p2);
	    pass = false;
	}
	if(!p3.equals(JAXRPC_Data.QName_data[0])) {
	    TestUtil.logErr("QName failed, expected " +
		JAXRPC_Data.QName_data[0] + ", received " + p3);
	    pass = false;
	}
	if(!p4.equals(JAXRPC_Data.String_data[0])) {
	    TestUtil.logErr("String failed, expected " +
		JAXRPC_Data.String_data[0] + ", received " + p4);
	    pass = false;
	}
	if(pass)
	    return "passed";
	else
	    return "failed";
    }

    public String invokeTest3() throws RemoteException {
	return "Hello";
    }

    public void invokeTest4() throws RemoteException, MyServiceException {
	throw new MyServiceException("My Service Exception");
    }

    public void invokeOneWayTest1(Boolean p1, Byte p2, Short p3, Integer p4,
        Long p5, Float p6, Double p7) throws RemoteException {

	return;
    }

    public void invokeOneWayTest2(BigInteger p1, BigDecimal p2, QName p3, 
		String p4) throws RemoteException {
	return;
    }

    public void invokeOneWayTest3() throws RemoteException {
    }
}
