/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
/*************************************************************************
   Licensed Materials - Property of IBM
   WSEE1.0 (C) Copyright International Business Machines Corp. 2002
   All Rights Reserved.
   US Government Users Restricted Rights - Use, duplication or
   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
**************************************************************************/
/*************************************************************************
   IBM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
   ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
   PURPOSE. IN NO EVENT SHALL IBM BE LIABLE FOR ANY SPECIAL, INDIRECT OR
   CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
   USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
   OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
   OR PERFORMANCE OF THIS SOFTWARE.
**************************************************************************/

/*
 * $Id: Constants.java 62536 2011-04-15 16:35:14Z af70133 $
 */

package com.sun.ts.tests.jaxrpc.common;

import com.sun.ts.lib.util.*;
import com.sun.ts.lib.porting.*;

public class Constants {

    // Standard namespace URI's
    public static final String ENVELOPE =
				"http://schemas.xmlsoap.org/soap/envelope/";
    public static final String URI_ENVELOPE = ENVELOPE;
    public static final String ENCODING =
				"http://schemas.xmlsoap.org/soap/encoding/";
    public static final String URI_ENCODING = ENCODING;
    public static final String XSD = 	
				"http://www.w3.org/2001/XMLSchema";
    public static final String XSI = 	
				"http://www.w3.org/2001/XMLSchema-instance";
    public static final String TRANSPORT_HTTP = 	
				"http://schemas.xmlsoap.org/soap/http/";
    public static final String URI_HTTP = TRANSPORT_HTTP;
    public static final String URI_SOAP_ACTOR_NEXT = 	
				"http://schema.xmlsoap.org/soap/actor/next";

    // Standard SOAP Element Tags
    public static final String TAG_ENVELOPE         = "Envelope";
    public static final String TAG_HEADER           = "Header";
    public static final String TAG_BODY             = "Body";

    public static final String ATTR_ACTOR           = "actor";
    public static final String ATTR_MUST_UNDERSTAND = "actor";
    public static final String ATTR_ENCODING_STYLE  = "encodingStyle";

    // Standard Properties for Call Interface
    public static final String CALL_USERNAME_PROPERTY =
				"javax.xml.rpc.security.auth.username";
    public static final String CALL_PASSWORD_PROPERTY =
				"javax.xml.rpc.security.auth.password";
    public static final String CALL_OPERATION_STYLE_PROPERTY =
				"javax.xml.rpc.soap.operation.style";
    public static final String CALL_SOAPACTION_USE_PROPERTY =
				"javax.xml.rpc.soap.http.soapaction.use";
    public static final String CALL_SOAPACTION_URI_PROPERTY =
				"javax.xml.rpc.soap.http.soapaction.uri";
    public static final String CALL_ENCODINGSTYLE_URI_PROPERTY =
				"javax.xml.rpc.encodingstyle.namespace.uri";

    // Standard Properties for Stub Configuration
    public static final String STUB_USERNAME_PROPERTY =
				"javax.xml.rpc.security.auth.username";
    public static final String STUB_PASSWORD_PROPERTY =
				"javax.xml.rpc.security.auth.password";
    public static final String ENDPOINT_PROPERTY =
				"javax.xml.rpc.service.endpoint.address";

    // Invalid Property values for Stub Configuration used for negative testing
    public static final String INVALID_PROPERTY = "javax.xml.rpc.foo.bar";
    public static final String NULL_PROPERTY = null;

    // Invalid URL's used for negative testing
    public static final String BAD_ABSOLUTE_URL = "bogus:/foobar";
    public static final String BAD_RELATIVE_URL = "/foobar";
}
