/*
 * Decompiled with CFR 0.152.
 */
package org.freebxml.omar.common.security;

import com.sun.xml.wss.KeyInfoHeaderBlock;
import com.sun.xml.wss.KeyInfoStrategy;
import com.sun.xml.wss.MessageFilter;
import com.sun.xml.wss.SecurableSoapMessage;
import com.sun.xml.wss.SecurityHeaderBlock;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.filter.FilterBase;
import java.util.logging.Level;
import javax.xml.soap.SOAPPart;
import org.freebxml.omar.common.security.ExtendedSignatureHeaderBlock;
import org.w3c.dom.Document;

public class ExtendedExportSignatureFilter
extends FilterBase
implements MessageFilter {
    private String algorithm;
    private String x509TokenId;

    public ExtendedExportSignatureFilter() throws XWSSecurityException {
    }

    public ExtendedExportSignatureFilter(KeyInfoStrategy keyInfoStrategy, String algorithm) throws XWSSecurityException {
        this.keyInfoStrategy = keyInfoStrategy;
        this.algorithm = algorithm;
    }

    public void init() throws XWSSecurityException {
        if (this.getParameter("x509TokenId") != null) {
            this.x509TokenId = this.getParameter("x509TokenId");
        }
        if (this.algorithm == null) {
            FilterBase.log.log(Level.SEVERE, "WSS0185.filterparameter.not.set", new Object[]{"algorithm"});
            throw new XWSSecurityException("filter parameter 'algorithm' was not set");
        }
        if (this.keyInfoStrategy == null) {
            FilterBase.log.log(Level.SEVERE, "WSS0185.filterparameter.not.set", new Object[]{"keyinfostrategy"});
            throw new XWSSecurityException("filter parameter 'keyinfostrategy' was not set");
        }
    }

    public void process(SecurableSoapMessage secureMessage) throws XWSSecurityException {
        SOAPPart soapPart = secureMessage.getSOAPPart();
        String signMethod = null;
        if (this.algorithm.equalsIgnoreCase("DSA")) {
            signMethod = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
        } else if (this.algorithm.equalsIgnoreCase("RSA")) {
            signMethod = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        } else {
            FilterBase.log.log(Level.SEVERE, "WSS0198.unsupported.signature.algorithm", signMethod);
            throw new XWSSecurityException("Unsupported Sign Algorithm: " + this.algorithm);
        }
        ExtendedSignatureHeaderBlock sigBlock = new ExtendedSignatureHeaderBlock((Document)soapPart, signMethod);
        KeyInfoHeaderBlock keyInfoBlock = sigBlock.getKeyInfoHeaderBlock();
        String alias = this.keyInfoStrategy.getAlias();
        this.keyInfoStrategy.setCertificate(secureMessage.getSecurityEnvironment().getCertificate(alias, true));
        this.keyInfoStrategy.insertKey(keyInfoBlock, secureMessage, this.x509TokenId);
        secureMessage.findOrCreateSecurityHeader().insertHeaderBlock((SecurityHeaderBlock)sigBlock);
        secureMessage.setFilterParameter("Signature", (Object)sigBlock);
        secureMessage.setFilterParameter("KeyInfoStrategy", (Object)this.keyInfoStrategy);
    }
}

