/*
 * Decompiled with CFR 0.152.
 */
package org.freebxml.omar.common;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;

public final class UUID
implements Serializable {
    private long mostSig;
    private long leastSig;

    public UUID(long mostSig, long leastSig) {
        this.mostSig = mostSig;
        this.leastSig = leastSig;
    }

    public UUID(DataInput in) throws IOException {
        this.mostSig = in.readLong();
        this.leastSig = in.readLong();
    }

    public long getMostSignificantBits() {
        return this.mostSig;
    }

    public long getLeastSignificantBits() {
        return this.leastSig;
    }

    public void writeBytes(DataOutput out) throws IOException {
        out.writeLong(this.mostSig);
        out.writeLong(this.leastSig);
    }

    public int hashCode() {
        return (int)(this.mostSig >> 32 ^ this.mostSig ^ this.leastSig >> 32 ^ this.leastSig);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UUID)) {
            return false;
        }
        UUID sid = (UUID)obj;
        return this.mostSig == sid.mostSig && this.leastSig == sid.leastSig;
    }

    public String toString() {
        return UUID.digits(this.mostSig >> 32, 8) + "-" + UUID.digits(this.mostSig >> 16, 4) + "-" + UUID.digits(this.mostSig, 4) + "-" + UUID.digits(this.leastSig >> 48, 4) + "-" + UUID.digits(this.leastSig, 12);
    }

    private static String digits(long val, int digits) {
        long hi = 1L << digits * 4;
        return Long.toHexString(hi | val & hi - 1L).substring(1);
    }
}

