/*
 * Decompiled with CFR 0.152.
 */
package org.freebxml.omar.common;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.activation.DataHandler;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.xml.registry.RegistryException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.freebxml.omar.common.RepositoryItem;
import org.w3c.dom.Element;

public class RepositoryItemImpl
implements RepositoryItem,
Cloneable {
    private Log log = LogFactory.getLog((String)(class$org$freebxml$omar$common$RepositoryItemImpl == null ? (class$org$freebxml$omar$common$RepositoryItemImpl = RepositoryItemImpl.class$("org.freebxml.omar.common.RepositoryItemImpl")) : class$org$freebxml$omar$common$RepositoryItemImpl).getName());
    private String id;
    private Element sigElement;
    private DataHandler handler;
    static /* synthetic */ Class class$org$freebxml$omar$common$RepositoryItemImpl;

    private RepositoryItemImpl() {
    }

    public RepositoryItemImpl(String id, Element sigElement, DataHandler handler) {
        this.id = id;
        this.sigElement = sigElement;
        this.handler = handler;
    }

    public RepositoryItemImpl(String id, DataHandler handler) {
        this.id = id;
        this.handler = handler;
    }

    public int getSize() throws IOException {
        InputStream is = this.handler.getInputStream();
        int size = 0;
        while (is.read() != -1) {
            ++size;
        }
        return size;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Element getSignatureElement() {
        return this.sigElement;
    }

    public DataHandler getDataHandler() {
        return this.handler;
    }

    public MimeMultipart getMimeMultipart() throws RegistryException {
        MimeMultipart mp = null;
        try {
            mp = new MimeMultipart();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer trans = tf.newTransformer();
            trans.transform(new DOMSource(this.sigElement), new StreamResult(os));
            MimeBodyPart bp1 = new MimeBodyPart();
            bp1.addHeader("Content-ID", "payload1");
            bp1.setText(os.toString(), "utf-8");
            mp.addBodyPart((BodyPart)bp1);
            MimeBodyPart bp2 = new MimeBodyPart();
            bp2.setDataHandler(this.handler);
            bp2.addHeader("Content-Type", this.handler.getContentType());
            bp2.addHeader("Content-ID", "payload2");
            mp.addBodyPart((BodyPart)bp2);
        }
        catch (MessagingException e) {
            throw new RegistryException((Throwable)e);
        }
        catch (TransformerException e) {
            throw new RegistryException((Throwable)e);
        }
        return mp;
    }

    public Object clone() throws CloneNotSupportedException {
        RepositoryItemImpl theClone = new RepositoryItemImpl();
        theClone.id = this.id;
        theClone.sigElement = this.sigElement;
        theClone.handler = this.handler;
        return theClone;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

