/*
 * Copyright (c) 1997-2017 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.api.javax.activation.MimeType;

import	java.io.*;
import	javax.activation.*;
import	com.sun.javatest.*;
import	com.sun.javatest.lib.MultiTest; 

/** Test: writeExternal(ObjectOutput); <p>
 *
 * The object implements the writeExternal method to save its contents
 * by calling the methods of DataOutput for its primitive values or
 * calling the writeObject method of ObjectOutput for objects, strings
 * and arrays. If this invocation is successfull then this test passes. <p>
 */

public class writeExternal_Test extends MultiTest
{
public static void main(String argv[])
{
	writeExternal_Test lTest = new writeExternal_Test();
	Status lStatus = lTest.run(argv, new PrintWriter(System.err, true), new PrintWriter(System.out, true));
	lStatus.exit();
}

public Status writeExternalTest()
{
	try {	// create MimeType object
		MimeType objmt =  new MimeType();

		if( objmt == null )
		    return Status.failed("Failed: to create MimeType object using a constructor");

		FileOutputStream fos = new FileOutputStream("junkwrite");

		if( fos == null )
		    return Status.failed("Failed to create FileOutputStream object.");

		ObjectOutputStream oos = new ObjectOutputStream((OutputStream)fos);

                if( oos == null )
                    return Status.failed("Failed to create ObjectOutputStream object.");

		objmt.writeExternal((ObjectOutput)oos);	// API TEST

	} catch(Exception ex) {
		ex.printStackTrace();
		return Status.failed("writeExternal(ObjectOutput) threw " + ex.toString());
	}

	return Status.passed("writeExternal(ObjectOutput) test succeeded");
}

}
