/*
 * Copyright (c) 1997-2017 Oracle and/or its affiliates. All rights reserved.
 */

package	javasoft.sqe.tests.api.javax.activation.FileDataSource;

import	java.io.*;
import	javax.activation.*;
import	com.sun.javatest.*;
import com.sun.javatest.lib.MultiTest; 
import	javasoft.sqe.tests.api.javax.activation.TestClasses.TestFileTypeMap;

/**
 * Create an instance of FileDataSource class and use it to call getName()
 * api, if this method returns non-null object then this testcase passes,
 * otherwise it fails. <p>
 */

public class getName_Test extends MultiTest
{
private static final String	kFileName = "FDSTestFile.txt";

public static void main(String argv[])
{
	getName_Test lTest = new getName_Test();
	Status lStatus = lTest.run(argv, new PrintWriter(System.err, true), new PrintWriter(System.out, true));
	lStatus.exit();
}

public Status getNameTest()
{
	FileDataSource fdsFromFile = new FileDataSource(new File(kFileName));
	FileDataSource fdsFromFileName = new FileDataSource(kFileName);
	String name1 = fdsFromFile.getName();		// API TEST
	String name2 = fdsFromFileName.getName();	// API TEST

	if( name1 == null )
	    return Status.failed("getName() test failed");
	if( name2 == null )
	    return Status.failed("getName() test failed");

	return Status.passed("getName() test passed");
}

}
