/*
 * Copyright (c) 1997-2017 Oracle and/or its affiliates. All rights reserved.
 */

package	javasoft.sqe.tests.api.javax.activation.DataHandler;

import	java.io.*;
import	javax.activation.*;
import	java.awt.datatransfer.*;
import	com.sun.javatest.*;
import	com.sun.javatest.lib.MultiTest; 
import	javasoft.sqe.tests.api.javax.activation.TestClasses.*;

/**
 * Using an instance of DataHandler object, invoke isDataFlavorSupported()
 * api, with a specified data flavors if it returns a boolean value then
 * this testcase passes.
 */

public class isDataFlavorSupported_Test extends MultiTest
{
private static final String	kFileName = "foo.txt";

public static void main(String argv[])
{
	isDataFlavorSupported_Test lTest = new isDataFlavorSupported_Test();
	Status lStatus = lTest.run(argv, new PrintWriter(System.err, true), new PrintWriter(System.out, true));
	lStatus.exit();
}

public Status isDataFlavorSupportedTest()
{	
    DataSource fds = new FileDataSource(kFileName);
    DataHandler dh1 = new DataHandler(fds);
    String mimeType = fds.getContentType();
    DataFlavor refdf = new DataFlavor(mimeType, "who cares?");
    dh1.setCommandMap(new TestCommandMap(mimeType));
    
    DataFlavor wrongMimeDF = new DataFlavor("moo/poo", "extraneous human readable name");

    if (!dh1.isDataFlavorSupported(refdf))	// API TEST
	return Status.failed("DataHandler(DataSource).isDataSupported(df) unexpected false");
	
    if (dh1.isDataFlavorSupported(wrongMimeDF))		// API TEST
	return Status.failed("DataHandler(DataSource).isDataSupported(wrongMimeDF) unexpected true");
	
    DataHandler dh2 = new DataHandler(new TestCommandObject(), "foo/goo");
    refdf = new DataFlavor("foo/goo", "anything goes");
    
    dh2.setCommandMap(new TestCommandMap("foo/goo"));
    
    wrongMimeDF = new DataFlavor("moo/poo", "extraneous human readable name");

    if (!dh2.isDataFlavorSupported(refdf))	// API TEST
	return Status.failed("DataHandler(Object,String).isDataSupported(df) unexpected false");
	
    if (dh2.isDataFlavorSupported(wrongMimeDF))		// API TEST
	return Status.failed("DataHandler(Object,String).isDataSupported(wrongMimeDF) unexpected true");

    return Status.passed("isDataFlavorSupported() test succeeded");
}

}
