/*
 * Copyright (c) 1997-2017 Oracle and/or its affiliates. All rights reserved.
 */

package	javasoft.sqe.tests.api.javax.activation.DataHandler;

import  java.io.*;
import  javax.activation.*;
import  com.sun.javatest.*;
import  javasoft.sqe.tests.api.javax.activation.TestClasses.*;

/** Create a DataHandler object then use it to invoke getBean() api,
 *  if it returns a non-null Object then this testcase passes,
 *  otherwise it fails. <p>
 */

public class getBean_Test implements Test
{
	public static void main(String argv[])
	{
		getBean_Test lTest = new getBean_Test();
		Status lStatus = lTest.run(argv, new PrintWriter(System.err, true), new PrintWriter(System.out, true));
		lStatus.exit();
	}

	public Status run(String argv[], PrintWriter outLog, PrintWriter outConsole)
	{
                String verb = "view";
                String className = "javasoft.sqe.tests.api.javax.activation.TestClasses.TestCommandObject";

		// get CommandInfo object
		CommandInfo lCommandInfo = new CommandInfo(verb, className);

		if(!(lCommandInfo instanceof CommandInfo))
	    	    return Status.failed("CommandInfo() failed to return CommandInfo object!");

		Object obj = new Object(); // just a random object
		DataHandler dhl = new DataHandler(obj, "foo/goo");

                if( dhl == null )
                    return Status.failed("DataHandler() failed to return DataHandler object!");

		Object bean = dhl.getBean(lCommandInfo);	// API TEST

		if( bean == null )
		    return Status.failed("getBean failed to return non-null Object!");

		return Status.passed("getBean() test succeeded");
	}
}
