/*
 * Copyright (c) 1997-2017 Oracle and/or its affiliates. All rights reserved.
 */

package	javasoft.sqe.tests.api.javax.activation.CommandMap;

import	java.io.*;
import	javax.activation.*;
import	com.sun.javatest.*;
import	javasoft.sqe.tests.api.javax.activation.TestClasses.*;

/** CommandMap is an abstract class. The main functional testing is in the only
 *  provided concrete implementation, MailcapCommandMap, done separately. <p>
 *  Get a CommandMap object by calling getDefaultCommandMap() api then call
 *  getAllCommands() api with string parameter if it returns a CommandInfo
 *  array object then this testcase passes otherwise it fails. <p>
 */

public class getAllCommands_Test implements Test
{
	public static void main(String argv[])
	{
		getAllCommands_Test lTest = new getAllCommands_Test();
		Status lStatus = lTest.run(argv, new PrintWriter(System.err, true), new PrintWriter(System.out, true));
		lStatus.exit();
	}

	public Status run(String argv[], PrintWriter outLog, PrintWriter outConsole)
	{
		// does getDefaultCommandMap return a MailcapCommandMap?
		CommandMap lCommandMap = CommandMap.getDefaultCommandMap();

		if (!(lCommandMap instanceof MailcapCommandMap))
	    	    return Status.failed("getDefaultCommandMap() did not return MailcapCommandMap");
	
		CommandInfo[] comap = lCommandMap.getAllCommands("text/plain");

		if( comap == null )
		    return Status.failed("getAllCommands failed to return CommandInfo array");

		return Status.passed("getAllCommands() Test succeeded");
	}
}
