/*
 * Copyright (c) 1996-2017 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.api.javax.activation.ActivationDataFlavor;

import java.io.*;
import java.awt.datatransfer.*;
import javax.activation.*;
import com.sun.javatest.*;
import com.sun.javatest.lib.MultiTest; 
import  javasoft.sqe.tests.api.javax.activation.TestClasses.*;

/**
 * We create a TestActivationDataFlavor object then invoke
 * testNormalizeMimeType() method which in turn calls
 * normalizeMimeType() api, if it returns the expected
 * string value then this testcase passes, otherwsie it fails.
 */

public class normalizeMimeType_Test extends MultiTest {

    // main
    public static void main(String[] args)
    { 
	Test t = new normalizeMimeType_Test(); 
	Status s = t.run(args, new PrintWriter(System.err, true), new PrintWriter(System.out, true)); 
	s.exit(); 
    }

    // Tests for equals:
    public Status normalizeMimeType()
    {
	String mimeType = "text/plain";
	String expectedValue = mimeType;

	// actual type doesn't matter
	TestActivationDataFlavor adf = new TestActivationDataFlavor("text/plain","My DataFlavor");

	if(expectedValue.equals(adf.testNormalizeMimeType(mimeType)))
	    return Status.passed("normalizeMimeType() test succeeded");
	else
	    return Status.failed("normalizeMimeType() test failed: "
				+ adf.testNormalizeMimeType(mimeType) + " != " + expectedValue);
    }
}
