/*
 * Decompiled with CFR 0.152.
 */
package javasoft.sqe.javatest.lib.apitest;

import javasoft.sqe.javatest.Status;
import javasoft.sqe.javatest.lib.MultiStatus;
import javasoft.sqe.javatest.lib.apitest.AssertionTest;
import javasoft.sqe.javatest.lib.apitest.Factory;
import javasoft.sqe.javatest.lib.apitest.Generator;

public class GridGenerator
implements Generator {
    private AssertionTest testObject;
    private Factory[] factory;
    private MultiStatus overallStatus;

    public Status run(AssertionTest testObject, Factory[] paramFactory) {
        this.testObject = testObject;
        this.factory = paramFactory;
        this.overallStatus = new MultiStatus();
        try {
            this.iterate(paramFactory);
        }
        catch (AssertionTest.Fault f) {
            return Status.failed(f.getMessage());
        }
        return this.overallStatus.getStatus();
    }

    public void init(String[] args) throws AssertionTest.Fault {
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (!args[i].equals("-reporter")) continue;
                throw new AssertionTest.Fault("There was no -end at the end of the argument list for Generator");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void iterate(Factory[] pFactory) throws AssertionTest.Fault {
        int[] fact = new int[pFactory.length];
        for (int j = 0; j < pFactory.length; ++j) {
            fact[j] = pFactory[j].getSize();
        }
        int factory_length = fact.length;
        int[] points = new int[fact.length];
        int i = 0;
        while (true) {
            block6: {
                if (points[i] < fact[i]) {
                    if (i == factory_length - 1) {
                        this.executeTestCase(points);
                        break block6;
                    } else {
                        points[++i] = 0;
                        continue;
                    }
                }
                if (--i < 0) {
                    return;
                }
            }
            int n = i;
            points[n] = points[n] + 1;
        }
    }

    private void executeTestCase(int[] p) throws AssertionTest.Fault {
        Object[] exeParameters = new Object[p.length - 1];
        Object objectUnderTest = null;
        String testID = String.valueOf(p[0]);
        try {
            objectUnderTest = this.factory[0].createElement(p[0]);
            for (int i = 1; i < p.length; ++i) {
                testID = testID + ":" + String.valueOf(p[i]);
                exeParameters[i - 1] = this.factory[i].createElement(p[i]);
            }
            Status testStatus = this.testObject.runTest(objectUnderTest, exeParameters, p);
            this.overallStatus.add(testID, testStatus);
            this.factory[0].disposeElement(objectUnderTest);
            for (int i = 1; i < this.factory.length; ++i) {
                this.factory[i].disposeElement(exeParameters[i - 1]);
            }
        }
        catch (AssertionTest.Fault f) {
            throw new AssertionTest.Fault(f.getMessage() + " Execution Signature at this point: " + testID);
        }
    }
}

