/*
 * Decompiled with CFR 0.152.
 */
package javasoft.sqe.javatest.lib;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import javasoft.sqe.javatest.Status;
import javasoft.sqe.javatest.lib.MultiTest;

public abstract class InteractiveTest
extends MultiTest {
    private Status status;
    private Panel panel = null;
    private Panel infoPanel = null;
    private Panel controlPanel = null;
    private Panel buttonPanel;
    private Panel failureInfoPanel = null;
    private TimePanel timePanel;
    private Panel userPanel;
    private Label userLabel;
    private TextField failureInfoField;
    private Button yesButton;
    private Button noButton;
    private Button doneButton;
    private GridBagLayout gridbag = new GridBagLayout();
    private GridBagConstraints c = new GridBagConstraints();
    private int timeout = 90;
    private int timeRemaining;
    private Thread timerThread;
    private boolean testExecutionPaused = false;
    private Listener listener = null;
    private String mode = null;
    private boolean testdirurlRequired = false;
    private String testdir = null;
    private boolean frameSizeSet = false;
    private Toolkit toolkit;
    private Dimension frameSize;
    private Dimension screenSize;
    private ScrollPane scrollPane = new ScrollPane();
    public Font XXXLrgDialogFont = new Font("Dialog", 0, 26);
    public Font XXLrgDialogFont = new Font("Dialog", 0, 24);
    public Font XLrgDialogFont = new Font("Dialog", 0, 22);
    public Font lrgDialogFont = new Font("Dialog", 0, 20);
    public Font medDialogFont = new Font("Dialog", 0, 16);
    public Font smDialogFont = new Font("Dialog", 0, 14);
    public Font XsmDialogFont = new Font("Dialog", 0, 12);
    protected Frame testFrame = null;
    protected String question = "";
    protected String doneInstruction = "Press Done when finished.";
    protected String passMessage = "";
    protected String failMessage = "";
    public String testdirurl = null;

    public InteractiveTest() {
        this("YesNo");
    }

    protected InteractiveTest(String mode) {
        this.mode = mode;
    }

    protected InteractiveTest(String mode, boolean testdirurlRequired) {
        this.mode = mode;
        this.testdirurlRequired = testdirurlRequired;
    }

    protected void init() throws MultiTest.SetupException {
        if (this.testdirurlRequired && this.testdirurl == null) {
            throw new MultiTest.SetupException("No TestDirURL specified");
        }
    }

    protected int decodeArg(String[] argv, int index) throws MultiTest.SetupException {
        if (argv[index].equals("-TestDirURL")) {
            if (++index < argv.length && !argv[index].startsWith("-")) {
                try {
                    this.testdirurl = argv[index].substring(0, argv[index].lastIndexOf("/") + 1);
                    URL testdirURL = new URL(this.testdirurl);
                    this.testdir = testdirURL.getProtocol().equals("file") ? testdirURL.getFile().replace('/', File.separatorChar) : "";
                    return 2;
                }
                catch (MalformedURLException e) {
                    throw new MultiTest.SetupException("Invalid URL: " + argv[index]);
                }
            }
            throw new MultiTest.SetupException("No TestDirURL specified");
        }
        return super.decodeArg(argv, index);
    }

    protected Status invokeTestCase(Method m) throws IllegalAccessException, InvocationTargetException {
        Object[] testArgs = new Object[]{};
        this.toolkit = Toolkit.getDefaultToolkit();
        this.screenSize = this.toolkit.getScreenSize();
        this.status = null;
        this.setUp();
        Object o = m.invoke((Object)this, testArgs);
        if (this.mode.equals("YesNo")) {
            this.createYNInterface();
        } else if (this.mode.equals("Done")) {
            this.createDoneInterface();
        }
        this.frameSize = this.testFrame.getSize();
        if (this.frameSize.width > this.screenSize.width || this.frameSize.height > this.screenSize.height) {
            this.testFrame.setSize(this.screenSize);
        }
        this.testFrame.setVisible(true);
        this.testExecutionPaused = false;
        this.timeRemaining = this.timeout;
        this.startRecordingTime();
        try {
            this.waitForStatus();
        }
        catch (InterruptedException e) {
            return Status.failed(e.toString());
        }
        this.cleanUp();
        return this.status;
    }

    protected synchronized void setStatus(Status status) {
        this.status = status;
        this.notify();
    }

    protected void startRecordingTime() {
        this.timePanel.start();
    }

    protected synchronized void waitForStatus() throws InterruptedException {
        try {
            while (this.status == null & this.timeRemaining > 0) {
                if (!this.testExecutionPaused) {
                    this.wait(1000L);
                    --this.timeRemaining;
                    continue;
                }
                this.wait(10000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.status == null) {
            this.status = Status.failed("No response from user.");
        }
    }

    protected synchronized void pauseTestExecution() {
        this.testExecutionPaused = true;
        this.notify();
    }

    protected synchronized void resumeTestExecution() {
        this.testExecutionPaused = false;
        this.notify();
    }

    protected void addInfo(String info) {
        this.infoPanel.add(new Label(info, 1));
    }

    protected void addTestPanel(Component testpanel) {
        this.addTestPanel("Center", testpanel);
    }

    protected void addTestPanel(String orientation, Component testpanel) {
        this.panel.add(orientation, testpanel);
    }

    protected void setQuestion(String question) {
        this.question = question;
    }

    protected void setStatusMessages(String passMessage, String failMessage) {
        this.passMessage = passMessage;
        this.failMessage = failMessage;
    }

    protected void setDoneInstruction(String doneInstruction) {
        this.doneInstruction = doneInstruction;
    }

    protected void setFrameTitle(String title) {
        this.testFrame.setTitle(title);
    }

    protected void setFrameSize(int width, int height) {
        this.testFrame.setSize(width, height);
    }

    protected void setTimeout(int seconds) {
        this.timeout = seconds;
    }

    protected int getTimeRemaining() {
        return this.timeRemaining;
    }

    protected void checkResult() {
        this.setStatus(Status.failed("No result checking was performed by test."));
    }

    protected void doTestCleanup() {
    }

    protected void setUp() {
        this.testFrame = new Frame();
        this.testFrame.setSize(640, 480);
        this.testFrame.setLayout(new BorderLayout());
        ((Component)this.testFrame).setBackground(Color.lightGray);
        this.panel = new Panel();
        this.panel.setLayout(new BorderLayout());
        this.infoPanel = new Panel();
        this.infoPanel.setLayout(new GridLayout(0, 1));
        this.infoPanel.setBackground(new Color(225, 235, 225));
        this.infoPanel.setForeground(Color.black);
        this.controlPanel = new Panel();
        this.controlPanel.setLayout(this.gridbag);
        this.controlPanel.setForeground(Color.black);
        this.panel.add("North", this.infoPanel);
        this.panel.add("South", this.controlPanel);
        this.scrollPane.add(this.panel);
        this.scrollPane.setScrollPosition(0, 0);
        this.testFrame.add("Center", this.scrollPane);
        this.listener = new Listener();
    }

    protected void cleanUp() {
        this.doTestCleanup();
        if (this.timePanel != null) {
            this.timePanel.stop();
        }
        if (this.testFrame != null) {
            this.testFrame.dispose();
        }
    }

    protected void createYNInterface() {
        this.userPanel = new Panel();
        this.userLabel = new Label(this.question, 1);
        this.buttonPanel = new Panel();
        this.failureInfoPanel = new Panel();
        this.yesButton = new Button("Yes");
        this.yesButton.setBackground(Color.green);
        this.yesButton.addActionListener(this.listener);
        this.noButton = new Button("No");
        this.noButton.setBackground(Color.red);
        this.noButton.addActionListener(this.listener);
        this.failureInfoField = new TextField();
        this.timePanel = new TimePanel();
        this.c.insets = new Insets(15, 0, 0, 0);
        this.c.gridwidth = 0;
        this.gridbag.setConstraints(this.timePanel, this.c);
        this.controlPanel.add(this.timePanel);
        this.c.insets = new Insets(30, 0, 10, 0);
        this.gridbag.setConstraints(this.userLabel, this.c);
        this.userLabel.setFont(new Font("Dialog", 1, 14));
        this.controlPanel.add(this.userLabel);
        this.buttonPanel.setLayout(new FlowLayout());
        this.buttonPanel.add(this.yesButton);
        this.buttonPanel.add(this.noButton);
        GridBagLayout gridbag2 = new GridBagLayout();
        GridBagConstraints c2 = new GridBagConstraints();
        this.failureInfoPanel.setLayout(gridbag2);
        c2.weightx = 1.0;
        c2.fill = 2;
        gridbag2.setConstraints(this.failureInfoField, c2);
        this.failureInfoField.setBackground(Color.white);
        this.failureInfoField.setForeground(Color.black);
        this.failureInfoPanel.add(this.failureInfoField);
        this.failureInfoField.addActionListener(this.listener);
        this.userPanel.setLayout(new CardLayout());
        this.userPanel.add("buttons", this.buttonPanel);
        this.userPanel.add("textfield", this.failureInfoPanel);
        this.c.insets = new Insets(0, 0, 10, 0);
        this.c.weightx = 1.0;
        this.c.fill = 2;
        this.gridbag.setConstraints(this.userPanel, this.c);
        this.controlPanel.add(this.userPanel);
    }

    protected void createDoneInterface() {
        Label dLabel = new Label(this.doneInstruction);
        this.doneButton = new Button("Done");
        this.doneButton.setBackground(Color.green);
        this.doneButton.setForeground(Color.black);
        this.doneButton.addActionListener(this.listener);
        this.timePanel = new TimePanel();
        this.c.insets = new Insets(15, 0, 0, 0);
        this.c.gridwidth = 0;
        this.gridbag.setConstraints(this.timePanel, this.c);
        this.controlPanel.add(this.timePanel);
        this.c.insets = new Insets(30, 0, 10, 0);
        this.gridbag.setConstraints(dLabel, this.c);
        dLabel.setFont(new Font("Dialog", 1, 14));
        this.controlPanel.add(dLabel);
        this.c.insets = new Insets(0, 0, 10, 0);
        this.gridbag.setConstraints(this.doneButton, this.c);
        this.controlPanel.add(this.doneButton);
    }

    protected void getFailureInfo() {
        ((CardLayout)this.userPanel.getLayout()).show(this.userPanel, "textfield");
        this.userLabel.setText("Please provide test failure details below and press <ENTER> or <RETURN>.");
        this.controlPanel.validate();
        this.testFrame.validate();
        this.failureInfoField.requestFocus();
    }

    protected void setButtonText(Object o, String newLabel) {
        ((Button)o).setLabel(newLabel);
    }

    protected Component getFailureInfoField() {
        return this.failureInfoField;
    }

    protected String getFailureInfoText() {
        return this.failureInfoField.getText();
    }

    protected class TimePanel
    extends Panel
    implements Runnable {
        private Label timeRemainingLabel;
        private Label timeRemainingField;
        private Button pauseButton;

        TimePanel() {
            this.setLayout(new FlowLayout());
            this.setBackground(new Color(120, 217, 255));
            this.timeRemainingLabel = new Label("Time remaining:");
            this.timeRemainingLabel.setForeground(Color.black);
            this.timeRemainingLabel.setFont(new Font("Dialog", 2, 14));
            this.timeRemainingField = new Label("      ");
            this.timeRemainingField.setForeground(Color.black);
            this.timeRemainingField.setFont(new Font("Dialog", 2, 14));
            this.pauseButton = new Button("Pause");
            this.pauseButton.setBackground(Color.yellow);
            this.pauseButton.setForeground(Color.black);
            this.add(this.timeRemainingLabel);
            this.add(this.timeRemainingField);
            this.add(new Label("           "));
            this.add(this.pauseButton);
            this.pauseButton.addActionListener(InteractiveTest.this.listener);
        }

        void start() {
            InteractiveTest.this.timerThread = new Thread(this);
            InteractiveTest.this.timerThread.start();
        }

        synchronized void stop() {
            InteractiveTest.this.timerThread = null;
            this.notify();
        }

        public synchronized void run() {
            try {
                Thread thisThread = Thread.currentThread();
                while (InteractiveTest.this.timerThread == thisThread) {
                    this.wait(1000L);
                    this.update();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private void update() {
            if (this.timeRemainingField != null) {
                this.timeRemainingField.setText(this.secondsToString(InteractiveTest.this.timeRemaining));
            }
        }

        private final String secondsToString(int time) {
            StringBuffer sb = new StringBuffer(5);
            int seconds = time % 60;
            int minutes = time / 60;
            if (minutes < 10) {
                sb.append('0');
            }
            sb.append(minutes);
            sb.append(':');
            if (seconds < 10) {
                sb.append('0');
            }
            sb.append(seconds);
            return sb.toString();
        }
    }

    protected class Listener
    implements ActionListener {
        protected Listener() {
        }

        public void actionPerformed(ActionEvent e) {
            String name = e.getActionCommand();
            Object source = e.getSource();
            Object b = null;
            if (name == "Yes") {
                InteractiveTest.this.setStatus(Status.passed(InteractiveTest.this.passMessage));
            } else if (name == "No") {
                InteractiveTest.this.setButtonText(source, "Resume");
                InteractiveTest.this.pauseTestExecution();
                InteractiveTest.this.getFailureInfo();
            } else if (name == "Done") {
                InteractiveTest.this.checkResult();
            } else if (name == "Pause") {
                InteractiveTest.this.setButtonText(source, "Resume");
                InteractiveTest.this.pauseTestExecution();
            } else if (name == "Resume") {
                InteractiveTest.this.setButtonText(source, "Pause");
                InteractiveTest.this.resumeTestExecution();
            } else if (source == InteractiveTest.this.getFailureInfoField()) {
                String failureInfo = InteractiveTest.this.getFailureInfoText();
                InteractiveTest.this.setStatus(Status.failed(InteractiveTest.this.failMessage + " " + failureInfo));
            }
        }
    }
}

