/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.services;

import com.sun.javatest.services.Message;
import com.sun.javatest.services.Service;
import com.sun.javatest.services.ServiceExecutor;
import com.sun.jck.services.DummyExecutor;
import com.sun.jck.services.LocalCommandBuilder;
import com.sun.jck.services.MessageConsumer;
import com.sun.jck.services.MutualService;
import com.sun.jck.services.RemoteCommandBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MessageProvider<T extends MessageConsumer>
extends MutualService {
    private Set<T> services = new HashSet<T>();

    public abstract Message[] prepareStartMessages() throws Service.MalformedParamsException;

    public abstract T createService(Message var1);

    @Override
    public synchronized boolean start() throws Service.NotConnectedException, Service.ServiceError {
        Message[] messageArray;
        this.stop();
        try {
            messageArray = this.prepareStartMessages();
        }
        catch (Service.MalformedParamsException malformedParamsException) {
            this.logMalformedException(malformedParamsException, Message.MessageType.START);
            return false;
        }
        boolean bl = true;
        for (int i = 0; i < messageArray.length; ++i) {
            T t = this.createService(messageArray[i]);
            ((Service)t).setProperties(this.props);
            this.getServices().add(t);
            bl = ((MessageConsumer)t).doMessage(messageArray[i]) & bl;
        }
        return bl;
    }

    @Override
    public synchronized boolean stop() throws Service.NotConnectedException, Service.ServiceError {
        boolean bl = true;
        Message message = new Message(Message.MessageType.STOP, null);
        Iterator<T> iterator = this.getServices().iterator();
        while (iterator.hasNext()) {
            MessageConsumer messageConsumer = (MessageConsumer)iterator.next();
            bl = messageConsumer.doMessage(message) & bl;
            iterator.remove();
        }
        return bl;
    }

    @Override
    public synchronized boolean isAlive() throws Service.NotConnectedException, Service.ServiceError {
        boolean bl = !this.services.isEmpty();
        Message message = new Message(Message.MessageType.IS_ALIVE, null);
        for (MessageConsumer messageConsumer : this.getServices()) {
            bl = messageConsumer.doMessage(message) & bl;
        }
        return bl;
    }

    @Override
    public ServiceExecutor getDefaultServiceExecutor() {
        return new DummyExecutor();
    }

    void logMalformedException(Service.MalformedParamsException malformedParamsException, Message.MessageType messageType) {
        Object object;
        String string = "Message malformed.\n";
        string = string + "Message type: " + messageType.toString() + "\n";
        Map<String, String> map = malformedParamsException.getParams();
        if (map != null && !map.isEmpty()) {
            string = string + "Parameters used:\n";
            object = map.keySet().iterator();
            while (object.hasNext()) {
                String string2 = (String)object.next();
                string = string + string2 + '=' + map.get(string2);
            }
        }
        if ((object = malformedParamsException.getDescription()) != null && ((String)object).length() > 0) {
            string = string + malformedParamsException.getDescription();
        }
        this.getLog().log(Level.SEVERE, string);
    }

    public Set<T> getServices() {
        return this.services;
    }

    protected Message[] addressMessages(LocalCommandBuilder localCommandBuilder) throws Service.MalformedParamsException {
        String string = this.getInterviewProperty("agent.hosts");
        String[] stringArray = string != null && string.length() > 0 ? string.split("[ ]+") : new String[1];
        ArrayList<Message> arrayList = new ArrayList<Message>();
        for (String string2 : stringArray) {
            RemoteCommandBuilder remoteCommandBuilder = new RemoteCommandBuilder(localCommandBuilder, string2);
            Message message = remoteCommandBuilder.getMessage();
            arrayList.add(message);
        }
        return arrayList.toArray(new Message[0]);
    }
}

