/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.services;

import com.sun.javatest.agent.ActiveAgentPool;
import com.sun.javatest.agent.AgentManager;
import com.sun.javatest.agent.Connection;
import com.sun.javatest.services.Message;
import com.sun.javatest.services.Service;
import com.sun.javatest.services.ServiceExecutor;
import com.sun.jck.services.LocalCommandBuilder;
import com.sun.jck.services.LoggingExecutor;
import com.sun.jck.services.MessageConsumer;
import com.sun.jck.services.MessageProvider;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActiveAgentService<T extends MessageConsumer>
extends MessageProvider {
    private int getAgentPort() {
        AgentManager agentManager = AgentManager.access();
        ActiveAgentPool activeAgentPool = agentManager.getActiveAgentPool();
        if (!activeAgentPool.isListening()) {
            return -1;
        }
        return activeAgentPool.getPort();
    }

    private void countActiveAgents(final CountDownLatch countDownLatch) {
        AgentManager agentManager = AgentManager.access();
        ActiveAgentPool activeAgentPool = agentManager.getActiveAgentPool();
        activeAgentPool.addObserver(new ActiveAgentPool.Observer(){

            public void addedToPool(Connection connection) {
                countDownLatch.countDown();
            }

            public void removedFromPool(Connection connection) {
            }
        });
    }

    public MessageConsumer createService(Message message) {
        return new MessageConsumer(this){

            public ServiceExecutor getDefaultServiceExecutor() {
                return new LoggingExecutor();
            }
        };
    }

    private static String hostname() throws UnknownHostException {
        InetAddress inetAddress = InetAddress.getLocalHost();
        String string = inetAddress.getCanonicalHostName();
        return string;
    }

    @Override
    public Message[] prepareStartMessages() throws Service.MalformedParamsException {
        int n;
        String string = this.getInterviewProperty("active.agent.service.command");
        String string2 = null;
        if (string.contains("@{host}")) {
            try {
                string2 = ActiveAgentService.hostname();
            }
            catch (UnknownHostException unknownHostException) {
                throw new Service.MalformedParamsException("Could not determine name of the local host", null);
            }
        }
        if ((n = this.getAgentPort()) == -1) {
            throw new Service.MalformedParamsException("Harness does not listen to agents", new HashMap<String, String>());
        }
        LocalCommandBuilder localCommandBuilder = new LocalCommandBuilder(this.props);
        localCommandBuilder.setValue(string, null);
        localCommandBuilder.setValue(String.valueOf(n), "@{port}");
        localCommandBuilder.setValue(string2, "@{host}");
        localCommandBuilder.setProperty("rmid.port", "@{rmi.port}");
        localCommandBuilder.setProperty("java.home", "@{java.home}");
        localCommandBuilder.setProperty("testsuite.root", "@{testsuite}");
        return this.addressMessages(localCommandBuilder);
    }

    @Override
    public Message prepareMessage(Message.MessageType messageType) throws Service.MalformedParamsException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean start() throws Service.NotConnectedException, Service.ServiceError {
        Message[] messageArray;
        try {
            messageArray = this.prepareStartMessages();
        }
        catch (Service.MalformedParamsException malformedParamsException) {
            this.logMalformedException(malformedParamsException, Message.MessageType.START);
            return false;
        }
        int n = messageArray.length;
        CountDownLatch countDownLatch = new CountDownLatch(n);
        boolean bl = true;
        this.countActiveAgents(countDownLatch);
        for (int i = 0; i < messageArray.length; ++i) {
            MessageConsumer messageConsumer = this.createService(messageArray[i]);
            messageConsumer.setProperties(this.props);
            this.getServices().add(messageConsumer);
            bl = messageConsumer.doMessage(messageArray[i]) & bl;
        }
        if (!bl) {
            return bl;
        }
        try {
            bl = countDownLatch.await(30L, TimeUnit.SECONDS);
            if (!bl) {
                Logger.getLogger(ActiveAgentService.class.getName()).log(Level.SEVERE, "Not all active agents were started: " + countDownLatch.getCount());
            }
        }
        catch (InterruptedException interruptedException) {
            Logger.getLogger(ActiveAgentService.class.getName()).log(Level.SEVERE, null, interruptedException);
        }
        return bl;
    }
}

