/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.lib.scriptgen;

import com.sun.jck.lib.scriptgen.BaseModel;
import com.sun.jck.lib.scriptgen.ScriptGen;
import java.io.File;
import java.util.Properties;

public class ShellModel
extends BaseModel {
    static final Properties toolsPath = ShellModel.initToolsPath();
    static final String currentDir = System.getProperty("user.dir");
    String lastClassPath = null;
    static final String PATH_SEP_VARNAME = "PATHSEP";
    static final String PATH_SEP = "${PATHSEP}";

    public String extention() {
        return ".ksh";
    }

    public String getVariable(String string) {
        return "$" + this.getVariableName(string);
    }

    public String getVariableName(String string) {
        if (string.startsWith("$")) {
            string = string.substring(1);
        }
        return string.toUpperCase().replaceAll("\\.", "_");
    }

    public String createContent() {
        BaseModel.Content content = new BaseModel.Content();
        if (this.getProduct() == 3 && this.isOptimizationMode()) {
            this.fixCP();
            this.fixWrapperScript();
        }
        this.generateHeader(content);
        this.generateContextSetting(content);
        this.generateDirCreation(content);
        this.generateActions(content);
        this.generateTail(content);
        return content.toString();
    }

    public void generateContextSetting(BaseModel.Content content) {
        for (String string : this.testContext.stringPropertyNames()) {
            String string2 = this.testContext.getProperty(string);
            content.ln(this.getVariableName(string) + "=${" + this.getVariableName(string) + ":-" + string2 + "}");
        }
        if (this.isWorkDirNeeded) {
            content.ln("TESTWORKDIR=${TESTWORKDIR:-/tmp/jck-workdir}");
            if (this.isDestDirNeeded) {
                content.ln("mkdir -p $TESTWORKDIR/classes");
            } else {
                content.ln("mkdir -p $TESTWORKDIR");
            }
            content.ln("if [ $? != 0 ] ; then echo \"Failed to create test work dir\"; exit 2 ; fi");
            content.ln("");
        }
        if (this.isPathSepNeeded) {
            content.ln("PATHSEP=\":\" ; if [ `uname -s |grep ^Windows` ] ;  then PATHSEP=\";\" ; fi");
        }
        for (int i = 0; i < this.pathToWrapperScript.length; ++i) {
            String string;
            if (this.pathToWrapperScript[i] == null) continue;
            string = this.getVariableName(WRAPPER_SCRIPTS[i]);
            content.ln(string + "=${" + string + ":-" + this.pathToWrapperScript[i] + "}");
            content.ln();
        }
    }

    protected void generateHeader(BaseModel.Content content) {
        content.ln("#!/bin/ksh");
        content.ln("######### " + this.getTestURL());
        if (this.negative) {
            content.ln("## NEGATIVE");
        }
        content.ln();
        if (this.getProduct() == 2) {
            content.ln("cd `dirname $0`");
            content.ln("TCK_HOME=${TCK_HOME:-`cd " + this.pathToRoot + "; pwd`}");
        } else {
            content.ln("if [ \"$TCK_HOME\" ] ; then");
            content.ln("   cd $TCK_HOME/" + this.relTestDir);
            content.ln("else");
            content.ln("   cd `dirname $0`");
            content.ln("   TCK_HOME=`cd " + this.pathToRoot + "; pwd`");
            content.ln("fi");
        }
        if (this.getProduct() == 3) {
            content.ln("export TCK_HOME");
        }
        content.ln();
    }

    protected void generateTail(BaseModel.Content content) {
        content.ln("echo \"-- passed\"; exit 0");
    }

    protected void generateActions(BaseModel.Content content) {
        for (int i = 0; i < this.actions.size(); ++i) {
            boolean bl;
            BaseModel.Action action = (BaseModel.Action)this.actions.get(i);
            boolean bl2 = bl = i == this.actions.size() - 1;
            if (action instanceof BaseModel.Command) {
                this.generateCommand(content, (BaseModel.Command)action, bl);
                continue;
            }
            if (action instanceof BaseModel.FindInDirAction) {
                this.generateFilesInDir(content, (BaseModel.FindInDirAction)action);
                continue;
            }
            System.err.println("Unknown action: " + action);
        }
    }

    protected void generateCommand(BaseModel.Content content, BaseModel.Command command, boolean bl) {
        this.generateClassPath(content, command.getClassPath());
        for (String string : command.getArgs()) {
            if ((string = this.adjustArg(string)) == null || string.trim().isEmpty()) continue;
            content.ap(string + " ");
        }
        content.ln("");
        this.generateStatusCheck(content, command, bl);
        content.ln("");
    }

    protected void generateStatusCheck(BaseModel.Content content, BaseModel.Command command, boolean bl) {
        if (this.negative && bl) {
            content.ln("if [ $? = " + command.getPosStatus() + " ] ; then " + "echo \"-- failed. Negative test failed \"; exit 1 ; fi");
        } else {
            content.ln("if [ $? != " + command.getPosStatus() + " ] ; then " + "echo \"-- failed \"; exit 1 ; fi");
        }
    }

    protected void generateClassPath(BaseModel.Content content, String string) {
        if (string == null || string.equals(this.lastClassPath)) {
            return;
        }
        if (this.lastClassPath == null) {
            if (this.isToolsJarRequired() && string.indexOf("tools.jar") < 0) {
                string = string + ":${JAVA_HOME}/lib/tools.jar";
            }
            content.ln("export CLASSPATH=\"" + this.fixPathSep(this.adjustArg(string)) + "\"");
            content.ln();
        } else if (string.startsWith(this.lastClassPath + File.pathSeparator)) {
            String string2 = string.substring((this.lastClassPath + File.pathSeparator).length());
            string2 = this.fixPathSep(this.adjustArg(string2));
            content.ln("export CLASSPATH=\"$CLASSPATH${PATHSEP}" + string2 + "\"");
            content.ln();
        } else if (string.endsWith(File.pathSeparator + this.lastClassPath)) {
            String string3 = string.substring(0, string.length() - (this.lastClassPath + File.pathSeparator).length());
            string3 = this.fixPathSep(this.adjustArg(string3));
            content.ln("export CLASSPATH=\"" + string3 + PATH_SEP + "$CLASSPATH\"");
            content.ln();
        } else {
            content.ln("export CLASSPATH=\"" + this.fixPathSep(this.adjustArg(string)) + "\"");
            content.ln();
        }
        this.lastClassPath = string;
    }

    protected String fixPathSep(String string) {
        if (string == null) {
            return null;
        }
        String string2 = File.pathSeparator;
        if ((string = string.replace(string2 + string2, string2)).startsWith(string2)) {
            string = string.substring(string2.length());
        }
        if (string.endsWith(string2)) {
            string = string.substring(0, string.length() - string2.length());
        }
        string = string.replace(string2, PATH_SEP);
        return string;
    }

    protected void fixCP() {
        for (BaseModel.Action action : this.actions) {
            if (!(action instanceof BaseModel.Command)) continue;
            BaseModel.Command command = (BaseModel.Command)action;
            int n = command.getArgs().size();
            for (int i = 0; i < n; ++i) {
                if (!command.getArg(i).equals("-cp") || i + 1 >= n) continue;
                command.setArg(i + 1, this.fixPathSep(command.getArg(i + 1)));
                this.isPathSepNeeded = true;
            }
        }
    }

    protected void fixWrapperScript() {
        for (int i = 0; i < this.pathToWrapperScript.length; ++i) {
            this.pathToWrapperScript[i] = null;
        }
        for (BaseModel.Action action : this.actions) {
            if (!(action instanceof BaseModel.Command)) continue;
            BaseModel.Command command = (BaseModel.Command)action;
            int n = command.getArgs().size();
            for (int i = 0; i < n; ++i) {
                String string = command.getArg(i);
                for (int j = 0; j < WRAPPER_SCRIPTS.length; ++j) {
                    String string2 = WRAPPER_SCRIPTS[j];
                    if (!string.equals("solaris/bin/" + string2 + ".sh") && !string.equals("linux/bin/" + string2 + ".sh") && !string.equals("win32\\bin\\" + string2 + ".bat")) continue;
                    command.setArg(i, this.getVariable(string2));
                    this.pathToWrapperScript[j] = "$TCK_HOME/" + string;
                }
            }
        }
    }

    protected String adjustArg(String string) {
        String string2;
        int n;
        String string3;
        int n2;
        if (string == null) {
            return "";
        }
        if (string.indexOf(124) >= 0 && !string.startsWith("\"") && !string.endsWith("\"")) {
            string = '\"' + string + '\"';
        }
        if (string.contains(currentDir)) {
            string = string.replace(currentDir, "$TCK_HOME");
        }
        if (string.equals("solaris/bin/xjc.sh") || string.equals("linux/bin/xjc.sh") || string.equals("win32\\bin\\xjc.bat") || string.equals("solaris/bin/schemagen.sh") || string.equals("linux/bin/schemagen.sh") || string.equals("win32\\bin\\schemagen.bat") || string.equals("solaris/bin/wsgen.sh") || string.equals("linux/bin/wsgen.sh") || string.equals("win32\\bin\\wsgen.bat") || string.equals("solaris/bin/wsimport.sh") || string.equals("linux/bin/wsimport.sh") || string.equals("win32\\bin\\wsimport.bat")) {
            return "$TCK_HOME/" + string;
        }
        String string4 = this.getPathToTools().getProperty(string);
        if (string4 != null) {
            return toolsPath.getProperty(string4);
        }
        if (string.startsWith(this.relTestDir)) {
            return string.substring(this.relTestDir.length());
        }
        if (string.startsWith(this.absoluteTestDir)) {
            return string.substring(this.absoluteTestDir.length());
        }
        if (string.startsWith("file:" + this.tckRootDir)) {
            return "file://" + this.getVariable("tck.home") + string.substring(("file:" + this.tckRootDir).length());
        }
        if (ScriptGen.workDirPath != null && (n2 = string.indexOf(ScriptGen.workDirPath)) >= 0) {
            string = string.substring(0, n2) + this.getVariable("testWorkDir") + string.substring(n2 + ScriptGen.workDirPath.length());
        }
        for (String string5 : this.testContext.stringPropertyNames()) {
            string3 = "{{" + string5 + "}}";
            n = string.indexOf(string3);
            if (n < 0) continue;
            string2 = this.getVariable(string5);
            string = string.substring(0, n) + string2 + string.substring(n + string3.length());
        }
        for (String string5 : ScriptGen.adjustedEnv.stringPropertyNames()) {
            string3 = "{{" + string5 + "}}";
            n = string.indexOf(string3);
            while (n >= 0) {
                string2 = this.getAdjustedValue(string5);
                if (string2 != null) {
                    string = string.substring(0, n) + string2 + string.substring(n + string3.length());
                }
                n = string.indexOf(string3);
            }
        }
        return string;
    }

    protected String getAdjustedValue(String string) {
        int n;
        String string2 = ScriptGen.adjustedEnv.getProperty(string);
        if (string2 == null) {
            return null;
        }
        int n2 = string2.indexOf("{{");
        while (n2 >= 0 && (n = string2.indexOf("}}", n2)) >= 0) {
            String string3 = string2.substring(n2 + 2, n);
            String string4 = null;
            string4 = string3.equals("relativeDir") ? this.relTestDir : (string3.equals("relativeURL") ? this.testURL : this.getVariable(string3));
            string2 = string2.substring(0, n2) + string4 + string2.substring(n + 2);
            n2 = string2.indexOf("{{", n2);
        }
        return string2;
    }

    private static Properties initToolsPath() {
        Properties properties = new Properties();
        properties.setProperty("java", "\"$JAVA_HOME/bin/java\"");
        properties.setProperty("refjava", "\"$JAVA_HOME/bin/java\"");
        properties.setProperty("javac", "\"$JAVA_HOME/bin/javac\"");
        properties.setProperty("rmic", "\"$JAVA_HOME/bin/rmic\"");
        properties.setProperty("shell", "$SHELL");
        return properties;
    }

    protected void generateDirCreation(BaseModel.Content content) {
        for (File file : this.dirsToCreate) {
            content.ln("mkdir -p " + this.adjustArg(file.getPath()));
        }
        content.ln();
    }

    protected void generateFilesInDir(BaseModel.Content content, BaseModel.FindInDirAction findInDirAction) {
        content.ln("LST=\"\"");
        content.ln("for i in " + this.adjustArg(findInDirAction.getDir()) + "/*" + findInDirAction.getFileExtention() + " ; do");
        content.ln("   LST=\"$LST" + findInDirAction.getSeparator() + "$i\"");
        content.ln("done");
        content.ln("LST=`echo $LST  | sed -e \"s/^;//\"`");
        content.ln("echo LST: $LST");
        content.ln();
    }
}

