/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.lib.scriptgen;

import com.sun.jck.lib.ScriptGenCommand;
import com.sun.jck.lib.scriptgen.ScriptGen;
import com.sun.jck.lib.scriptgen.ScriptModel;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public abstract class BaseModel
implements ScriptModel {
    protected String testURL;
    protected String pathToRoot;
    protected String tckRootDir;
    protected String absoluteTestDir;
    protected String relTestDir;
    protected boolean negative = false;
    protected boolean optimizationMode = false;
    protected boolean isToolsJarRequired;
    protected int product;
    protected boolean isWorkDirNeeded = false;
    protected boolean isDestDirNeeded = false;
    protected boolean isPathSepNeeded = false;
    protected static final String[] WRAPPER_SCRIPTS = new String[]{"schemagen", "xjc", "wsgen", "wsimport"};
    protected String[] pathToWrapperScript = new String[]{null, null, null, null};
    protected List<Action> actions;
    protected List<File> dirsToCreate = new ArrayList<File>();
    protected Properties pathToTools;
    protected Properties testContext;

    public BaseModel() {
        this.actions = new ArrayList<Action>();
    }

    public String getTestURL() {
        return this.testURL;
    }

    public void setTestURL(String string) {
        this.testURL = string = string.replace(File.separator, "/");
        this.relTestDir = "tests/" + new File(string).getParent().replace(File.separator, "/");
        this.pathToRoot = this.relTestDir.replaceAll("[^/]*/", "../").replaceAll("/[^/]*$", "/..");
        this.absoluteTestDir = this.tckRootDir + File.separator + this.relTestDir;
        if (!this.absoluteTestDir.endsWith(File.separator)) {
            this.absoluteTestDir = this.absoluteTestDir + File.separator;
        }
        if (!this.relTestDir.endsWith("/")) {
            this.relTestDir = this.relTestDir + "/";
        }
    }

    public String getRelativeTestDir() {
        return this.relTestDir;
    }

    public String getPathToRoot() {
        return this.pathToRoot;
    }

    public void setTCKRootDir(String string) {
        this.tckRootDir = string;
    }

    public String getTCKRootDir() {
        return this.tckRootDir;
    }

    public boolean isNegative() {
        return this.negative;
    }

    public void setNegative(boolean bl) {
        this.negative = bl;
    }

    public boolean isOptimizationMode() {
        return this.optimizationMode;
    }

    public void setOptimizationMode(boolean bl) {
        this.optimizationMode = bl;
    }

    public boolean isToolsJarRequired() {
        return this.isToolsJarRequired;
    }

    public void setToolsJarRequired(boolean bl) {
        this.isToolsJarRequired = bl;
    }

    public void setPathToTools(Properties properties) {
        this.pathToTools = properties;
    }

    public Properties getPathToTools() {
        return this.pathToTools;
    }

    public void eliminateArgs() {
        for (Action action : this.actions) {
            if (!(action instanceof Command)) continue;
            ((Command)action).eliminateArgs();
        }
    }

    public void extraContext() {
        for (Action action : this.actions) {
            if (!(action instanceof Command)) continue;
            ((Command)action).extraContext();
        }
    }

    public void extractClassPath() {
        for (Action action : this.actions) {
            if (!(action instanceof Command)) continue;
            ((Command)action).extractClassPath();
        }
    }

    public final String getContent() {
        if (this.optimizationMode) {
            this.eliminateArgs();
            this.extractClassPath();
        }
        this.extraContext();
        this.detectIsWorkDirNeeded();
        this.detectIsPathSepNeeded();
        return this.createContent();
    }

    public void setProduct(int n) {
        this.product = n;
    }

    public int getProduct() {
        return this.product;
    }

    public abstract String createContent();

    public void invokeCommand(String[] stringArray) {
        this.actions.add(new Command(stringArray));
    }

    public void mkdirs(File file) {
        if (file != null) {
            this.dirsToCreate.add(file);
        }
    }

    public void filesInDir(File file, String string, String string2, boolean bl) {
        this.actions.add(new FindInDirAction(file.getPath(), string, string2, bl));
    }

    protected void detectIsWorkDirNeeded() {
        this.isWorkDirNeeded = false;
        this.isDestDirNeeded = false;
        String string = ScriptGen.workDirPath;
        for (Action action : this.actions) {
            if (!(action instanceof Command)) continue;
            for (String string2 : ((Command)action).getArgs()) {
                for (String string3 : ScriptGen.depsOnWorkDir) {
                    if (string2.indexOf(string3) < 0 && (string == null || string2.indexOf(string) < 0)) continue;
                    this.isWorkDirNeeded = true;
                    if (string2.indexOf(string + File.separator + "classes") < 0) continue;
                    this.isDestDirNeeded = true;
                    return;
                }
            }
        }
    }

    protected void detectIsPathSepNeeded() {
        this.isPathSepNeeded = false;
        if (this.isToolsJarRequired()) {
            this.isPathSepNeeded = true;
            return;
        }
        for (Action action : this.actions) {
            String string;
            if (!(action instanceof Command) || (string = ((Command)action).getClassPath()) == null || string.indexOf(File.pathSeparator) < 0) continue;
            this.isPathSepNeeded = true;
            return;
        }
    }

    public void setContext(Properties properties) {
        this.testContext = properties;
    }

    public Properties getContext() {
        return this.testContext;
    }

    class Content {
        StringBuffer sb = new StringBuffer();

        Content() {
        }

        public void ap(String string) {
            this.sb.append(string);
        }

        public void ln(String string) {
            this.sb.append(string);
            this.sb.append("\n");
        }

        public void ln() {
            this.sb.append("\n");
        }

        public String toString() {
            return this.sb.toString();
        }
    }

    class FindInDirAction
    implements Action {
        private String dir;
        private String fileExtention;
        private String separator;
        private boolean canBeEmpty;

        FindInDirAction(String string, String string2, String string3, boolean bl) {
            this.setDir(string);
            this.setFileExtention(string2);
            this.setSeparator(string3);
            this.setCanBeEmpty(bl);
        }

        public String getDir() {
            return this.dir;
        }

        public void setDir(String string) {
            this.dir = string;
        }

        public String getFileExtention() {
            return this.fileExtention;
        }

        public void setFileExtention(String string) {
            this.fileExtention = string;
        }

        public String getSeparator() {
            return this.separator;
        }

        public void setSeparator(String string) {
            this.separator = string;
        }

        public boolean isCanBeEmpty() {
            return this.canBeEmpty;
        }

        public void setCanBeEmpty(boolean bl) {
            this.canBeEmpty = bl;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Command
    implements Action {
        String command;
        List<String> args;
        String classPath = null;
        int posStatus = 0;
        int negStatus = 1;

        Command() {
        }

        Command(String[] stringArray) {
            this(ScriptGen.asList(stringArray));
        }

        Command(List<String> list) {
            if (list == null) {
                throw new IllegalArgumentException("null args");
            }
            if (list.size() > 0) {
                this.setCommand(list.remove(0));
            }
            this.setArgs(list);
            this.resolveArgs();
        }

        public String getCommand() {
            return this.command;
        }

        public void setCommand(String string) {
            this.command = string;
            if (string != null && string.endsWith("ExecJCKTestOtherJVMCmd") || string.endsWith("ExecStdTestOtherJVMCmd")) {
                this.posStatus = 95;
                this.negStatus = 97;
            } else {
                this.posStatus = 0;
                this.negStatus = 1;
            }
        }

        public void setArgs(List<String> list) {
            this.args = list;
        }

        public void eliminateArgs() {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : this.args) {
                if (string.equals("-Xfuture") || string.startsWith("-Djava.security.policy=") || string.startsWith("LD_LIBRARY_PATH=") || string.startsWith("DISPLAY=") || string.startsWith("HOME=") || string.startsWith("JAVA_HOME=") || string.startsWith("PATH=") || string.startsWith("SystemRoot=") || string.startsWith("TMP=") || string.startsWith("TEMP=")) continue;
                arrayList.add(string);
            }
            this.setArgs(arrayList);
        }

        public void extraContext() {
            if (BaseModel.this.testContext == null) {
                return;
            }
            String[] stringArray = new String[]{"ORBInitialPort", "ORBInitialHost", "orbPort", "orbHost", "JavaSecurityKrb5KDC", "KDCHostName", "JavaSecurityKrb5Realm", "KDCRealm", "KerberosServerUsername", "KerberosServerPassword", "KerberosClientUsername", "KerberosClientPassword", "Classpath"};
            List<String> list = Arrays.asList(stringArray);
            for (int i = 0; i < this.args.size(); ++i) {
                String string = this.args.get(i);
                if (!string.startsWith("-") || i + 1 >= this.args.size() || !list.contains(string.substring(1))) continue;
                String string2 = this.args.get(++i);
                String string3 = string.substring(1);
                if (string3.equals("Classpath")) {
                    string3 = "static.sigtest.classpath";
                }
                this.args.set(i, "{{" + string3 + "}}");
                BaseModel.this.testContext.setProperty(string3, string2);
            }
        }

        public void extractClassPath() {
            for (int i = 0; i < this.args.size(); ++i) {
                String string = this.args.get(i);
                if (!string.startsWith("CLASSPATH=")) continue;
                this.classPath = string.substring("CLASSPATH=".length());
                this.args.remove(i);
                return;
            }
        }

        public List<String> getArgs() {
            return this.args;
        }

        public String getArg(int n) {
            return this.args.get(n);
        }

        public void setArg(int n, String string) {
            this.args.set(n, string);
        }

        private void resolveArgs() {
            try {
                Class<?> clazz = Class.forName(this.command);
                if (ScriptGenCommand.class.isAssignableFrom(clazz)) {
                    ScriptGenCommand scriptGenCommand = (ScriptGenCommand)clazz.newInstance();
                    String[] stringArray = scriptGenCommand.getCommandLine(this.args.toArray(new String[0]));
                    this.setArgs(ScriptGen.asList(stringArray));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public int getPosStatus() {
            return this.posStatus;
        }

        public int getNegStatus() {
            return this.negStatus;
        }

        public String getClassPath() {
            return this.classPath;
        }
    }

    static interface Action {
    }
}

